/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.nodes;

import com.android.jack.ir.ast.JLongLiteral;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.v0002.io.ExportSession;
import com.android.jack.jayce.v0002.io.ImportHelper;
import com.android.jack.jayce.v0002.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0002.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0002.io.Token;
import com.android.jack.jayce.v0002.nodes.NLiteral;
import com.android.jack.jayce.v0002.nodes.NSourceInfo;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NLongLiteral
extends NLiteral {
    @Nonnull
    public static final Token TOKEN = Token.LONG_LITERAL;
    public long value;
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JLongLiteral jLongLiteral = (JLongLiteral)node;
        this.value = jLongLiteral.getValue();
        this.sourceInfo = loader.load(jLongLiteral.getSourceInfo());
    }

    @Override
    @Nonnull
    public JLongLiteral exportAsJast(@Nonnull ExportSession exportSession) {
        assert (this.sourceInfo != null);
        SourceInfo jSourceInfo = this.sourceInfo.exportAsJast(exportSession);
        JLongLiteral jLongLiteral = new JLongLiteral(jSourceInfo, this.value);
        return jLongLiteral;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeLong(this.value);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.value = in.readLong();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

