/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.nodes;

import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JLocalUnresolved;
import com.android.jack.jayce.linker.LocalRefLinker;
import com.android.jack.jayce.v0002.io.ExportSession;
import com.android.jack.jayce.v0002.io.ImportHelper;
import com.android.jack.jayce.v0002.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0002.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0002.io.Token;
import com.android.jack.jayce.v0002.nodes.NExpression;
import com.android.jack.jayce.v0002.nodes.NSourceInfo;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NLocalRef
extends NExpression {
    @Nonnull
    public static final Token TOKEN = Token.LOCAL_REF;
    @CheckForNull
    public String localId;
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JLocalRef jLocalRef = (JLocalRef)node;
        this.localId = loader.getLocalSymbols().getId(jLocalRef.getLocal());
        this.sourceInfo = loader.load(jLocalRef.getSourceInfo());
    }

    @Override
    @Nonnull
    public JLocalRef exportAsJast(@Nonnull ExportSession exportSession) {
        assert (this.sourceInfo != null);
        assert (this.localId != null);
        JLocalRef jLocalRef = JLocalUnresolved.INSTANCE.makeRef(this.sourceInfo.exportAsJast(exportSession));
        exportSession.getLocalResolver().addLink(this.localId, new LocalRefLinker(jLocalRef));
        return jLocalRef;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeId(this.localId);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.localId = in.readId();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

