/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.nodes;

import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.v0002.io.ExportSession;
import com.android.jack.jayce.v0002.io.ImportHelper;
import com.android.jack.jayce.v0002.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0002.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0002.io.Token;
import com.android.jack.jayce.v0002.nodes.NLiteral;
import com.android.jack.jayce.v0002.nodes.NSourceInfo;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NIntLiteral
extends NLiteral {
    @Nonnull
    public static final Token TOKEN = Token.INT_LITERAL;
    public int value;
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JIntLiteral jIntLiteral = (JIntLiteral)node;
        this.value = jIntLiteral.getIntValue();
        this.sourceInfo = loader.load(jIntLiteral.getSourceInfo());
    }

    @Override
    @Nonnull
    public JIntLiteral exportAsJast(@Nonnull ExportSession exportSession) {
        assert (this.sourceInfo != null);
        SourceInfo jSourceInfo = this.sourceInfo.exportAsJast(exportSession);
        JIntLiteral jIntLiteral = new JIntLiteral(jSourceInfo, this.value);
        return jIntLiteral;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeInt(this.value);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.value = in.readInt();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

