/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.nodes;

import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JInstanceOf;
import com.android.jack.ir.ast.JReferenceType;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.v0002.io.ExportSession;
import com.android.jack.jayce.v0002.io.ImportHelper;
import com.android.jack.jayce.v0002.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0002.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0002.io.Token;
import com.android.jack.jayce.v0002.nodes.NExpression;
import com.android.jack.jayce.v0002.nodes.NSourceInfo;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NInstanceOf
extends NExpression {
    @Nonnull
    public static final Token TOKEN = Token.INSTANCE_OF;
    @CheckForNull
    public NExpression expr;
    @CheckForNull
    public String testType;
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JInstanceOf jInstanceOf = (JInstanceOf)node;
        this.expr = (NExpression)loader.load(jInstanceOf.getExpr());
        this.testType = ImportHelper.getSignatureName(jInstanceOf.getTestType());
        this.sourceInfo = loader.load(jInstanceOf.getSourceInfo());
    }

    @Override
    @Nonnull
    public JInstanceOf exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        assert (this.expr != null);
        assert (this.testType != null);
        JExpression jExpr = this.expr.exportAsJast(exportSession);
        JReferenceType jType = (JReferenceType)exportSession.getLookup().getType(this.testType);
        SourceInfo jSourceInfo = this.sourceInfo.exportAsJast(exportSession);
        JInstanceOf jInstanceOf = new JInstanceOf(jSourceInfo, jType, jExpr);
        return jInstanceOf;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeNode(this.expr);
        out.writeId(this.testType);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.expr = in.readNode(NExpression.class);
        this.testType = in.readId();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

