/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce;

import com.android.jack.Jack;
import com.android.jack.JackAbortException;
import com.android.jack.jayce.JayceFormatException;
import com.android.jack.jayce.JayceHeader;
import com.android.jack.jayce.JayceInternalReader;
import com.android.jack.library.InputJackLibrary;
import com.android.jack.library.LibraryFormatException;
import com.android.jack.library.LibraryReadingException;
import com.android.jack.library.MissingLibraryPropertyException;
import com.android.jack.reporting.Reporter;
import com.android.sched.util.log.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public abstract class JayceReaderFactory {
    @Nonnull
    private static Logger logger = LoggerFactory.getLogger();

    @Nonnull
    public static JayceInternalReader get(@Nonnull InputJackLibrary inputJackLibrary, @Nonnull InputStream in) throws LibraryFormatException {
        String majorVersionStr;
        try {
            majorVersionStr = inputJackLibrary.getProperty(inputJackLibrary.keyJayceMajorVersion);
        }
        catch (MissingLibraryPropertyException e) {
            logger.log(Level.SEVERE, e.getMessage());
            throw new LibraryFormatException(inputJackLibrary.getLocation());
        }
        int majorVersion = inputJackLibrary.getJayceMajorVersion();
        int minorVersion = inputJackLibrary.getJayceMinorVersion();
        JayceInternalReader jayceReader = (JayceInternalReader)JayceReaderFactory.instantiateConstructorWithParameters(inputJackLibrary.getJayceReaderConstructor(), new Object[]{in}, majorVersionStr);
        int minorMin = jayceReader.getMinorMin();
        int currentMinor = jayceReader.getCurrentMinor();
        if (minorVersion < minorMin) {
            logger.log(Level.SEVERE, "Library " + inputJackLibrary.getLocation().getDescription() + " is invalid: the version of the jayce file is not supported anymore. " + "File version: " + majorVersionStr + "." + minorVersion + " - Current version: " + majorVersionStr + "." + currentMinor + " - Minimum compatible version: " + majorVersionStr + "." + minorMin);
            throw new LibraryFormatException(inputJackLibrary.getLocation());
        }
        if (minorVersion > currentMinor) {
            logger.log(Level.SEVERE, "Library " + inputJackLibrary.getLocation().getDescription() + " is invalid: the version of the jayce file is too recent. " + "File version: " + majorVersionStr + "." + minorVersion + " - Current version: " + majorVersionStr + "." + currentMinor);
            throw new LibraryFormatException(inputJackLibrary.getLocation());
        }
        if (minorVersion < currentMinor) {
            Jack.getSession().getUserLogger().log(Level.WARNING, "The version of the jayce file is older than the current version but is supported. File version: {0}.{1} - Current version: {2}.{3}", new Object[]{Integer.valueOf(majorVersionStr), minorVersion, Integer.valueOf(majorVersionStr), currentMinor});
        }
        if (majorVersion == 2 && minorVersion == 14) {
            try {
                new JayceHeader(in);
            }
            catch (JayceFormatException e) {
                logger.log(Level.SEVERE, "Library " + inputJackLibrary.getLocation().getDescription() + " is invalid", e);
                throw new LibraryFormatException(inputJackLibrary.getLocation());
            }
            catch (IOException e) {
                LibraryReadingException exceptionToReport = new LibraryReadingException(e);
                Jack.getSession().getReporter().report(Reporter.Severity.FATAL, exceptionToReport);
                throw new JackAbortException(exceptionToReport);
            }
        }
        return jayceReader;
    }

    @Nonnull
    private static Object instantiateConstructorWithParameters(@Nonnull Constructor<?> constructor, @Nonnull Object[] parameterInstances, @Nonnull String version) {
        Object constructorInstance = null;
        try {
            constructorInstance = constructor.newInstance(parameterInstances);
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)"Security issue with Jayce stream");
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)("Illegal argument for Jayce processor for version " + version));
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)("Problem instantiating Jayce processor for version " + version));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)("Problem accessing Jayce processor for version " + version));
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        return constructorInstance;
    }
}

