/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce;

import com.android.jack.LibraryException;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JSession;
import com.android.jack.jayce.JayceMethodLoader;
import com.android.jack.jayce.MethodNode;
import com.android.jack.jayce.NodeLevel;
import com.android.jack.jayce.ParameterNode;
import com.android.jack.library.HasInputLibrary;
import com.android.jack.library.InputLibrary;
import com.android.jack.library.LibraryFormatException;
import com.android.jack.library.LibraryIOException;
import com.android.jack.load.JackLoadingException;
import com.android.jack.load.ParameterLoader;
import com.android.sched.marker.Marker;
import com.android.sched.util.location.Location;
import java.lang.ref.SoftReference;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class JayceParameterLoader
implements ParameterLoader,
HasInputLibrary {
    @Nonnull
    private final JayceMethodLoader enclosingMethodLoader;
    @Nonnull
    private SoftReference<ParameterNode> nnode;
    @Nonnegative
    private final int parameterNodeIndex;
    private boolean isAnnotationsLoaded = false;

    public JayceParameterLoader(@Nonnull ParameterNode nnode, @Nonnegative int parameterNodeIndex, @Nonnull JayceMethodLoader enclosingMethodLoader) {
        this.enclosingMethodLoader = enclosingMethodLoader;
        this.nnode = new SoftReference<ParameterNode>(nnode);
        this.parameterNodeIndex = parameterNodeIndex;
    }

    @Nonnull
    private ParameterNode getNNode() throws LibraryFormatException, LibraryIOException {
        ParameterNode node = this.nnode.get();
        if (node == null) {
            MethodNode declaredMethodNode = this.enclosingMethodLoader.getNNode(NodeLevel.STRUCTURE);
            node = declaredMethodNode.getParameterNode(this.parameterNodeIndex);
            this.nnode = new SoftReference<ParameterNode>(node);
        }
        return node;
    }

    @Override
    @Nonnull
    public Location getLocation(@Nonnull JParameter loaded) {
        return this.enclosingMethodLoader.getLocation(loaded.getEnclosingMethod());
    }

    @Override
    public void ensureMarkers(@Nonnull JParameter loaded) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureAnnotations(@Nonnull JParameter loaded) {
        JayceParameterLoader jayceParameterLoader = this;
        synchronized (jayceParameterLoader) {
            if (this.isAnnotationsLoaded) {
                return;
            }
            try {
                ParameterNode node = this.getNNode();
                node.loadAnnotations(loaded, this);
            }
            catch (LibraryException e) {
                throw new JackLoadingException(this.getLocation(loaded), e);
            }
            this.isAnnotationsLoaded = true;
        }
        loaded.removeLoader();
    }

    @Override
    @Nonnull
    public InputLibrary getInputLibrary() {
        return this.enclosingMethodLoader.getInputLibrary();
    }

    @Override
    public void ensureMarker(@Nonnull JParameter loaded, @Nonnull Class<? extends Marker> cls) {
        this.ensureMarkers(loaded);
    }

    @Override
    public void ensureAnnotation(@Nonnull JParameter loaded, @Nonnull JAnnotationType annotation) {
        this.ensureAnnotations(loaded);
    }

    @Nonnull
    public JSession getSession() {
        return this.enclosingMethodLoader.getSession();
    }
}

