/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.sourceinfo;

import com.android.jack.ir.sourceinfo.FileSourceInfo;
import com.android.jack.ir.sourceinfo.UnknownSourceInfo;
import com.android.sched.util.location.ColumnAndLineLocation;
import com.android.sched.util.location.FileLocation;
import com.android.sched.util.location.HasLocation;
import com.android.sched.util.location.Location;
import com.android.sched.util.location.NoLocation;
import javax.annotation.Nonnull;

public abstract class SourceInfo
implements HasLocation {
    public static final int UNKNOWN_LINE_NUMBER = 0;
    public static final int UNKNOWN_COLUMN_NUMBER = 0;
    @Nonnull
    public static final SourceInfo UNKNOWN = new UnknownSourceInfo();

    @Nonnull
    public String getFileName() {
        return this.getFileSourceInfo().getFileName();
    }

    @Nonnull
    public abstract FileSourceInfo getFileSourceInfo();

    public int getStartLine() {
        return 0;
    }

    public int getEndLine() {
        return 0;
    }

    public int getStartColumn() {
        return 0;
    }

    public int getEndColumn() {
        return 0;
    }

    @Override
    @Nonnull
    public Location getLocation() {
        Location location = NoLocation.getInstance();
        if (this != UNKNOWN) {
            FileLocation fileLocation = new FileLocation(this.getFileName());
            if (this.getStartLine() != 0) {
                int endColumn;
                int startColumn;
                int endLine = this.getEndLine();
                if (endLine == 0) {
                    endLine = -1;
                }
                if ((startColumn = this.getStartColumn()) == 0) {
                    startColumn = -1;
                }
                if ((endColumn = this.getEndColumn()) == 0) {
                    endColumn = -1;
                }
                location = new ColumnAndLineLocation(fileLocation, this.getStartLine(), endLine, startColumn, endColumn);
            } else {
                location = fileLocation;
            }
        }
        return location;
    }
}

