/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.sourceinfo;

import com.android.jack.ir.sourceinfo.FileSourceInfo;
import com.android.jack.ir.sourceinfo.LineSourceInfo;
import com.android.jack.ir.sourceinfo.SourceInfo;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

class ColumnSourceInfo
extends SourceInfo {
    @Nonnegative
    private final int endCol;
    @Nonnegative
    private final int startCol;
    @Nonnull
    private final LineSourceInfo lineSourceInfo;

    ColumnSourceInfo(@Nonnull LineSourceInfo location, @Nonnegative int startCol, @Nonnegative int endCol) {
        assert (startCol != 0);
        this.lineSourceInfo = location;
        this.startCol = startCol;
        this.endCol = endCol;
    }

    @Override
    @Nonnegative
    public int getEndColumn() {
        return this.endCol;
    }

    @Override
    @Nonnegative
    public int getStartColumn() {
        return this.startCol;
    }

    @Override
    @Nonnegative
    public int getStartLine() {
        return this.lineSourceInfo.getStartLine();
    }

    @Override
    @Nonnegative
    public int getEndLine() {
        return this.lineSourceInfo.getEndLine();
    }

    @Override
    @Nonnull
    public FileSourceInfo getFileSourceInfo() {
        return this.lineSourceInfo.getFileSourceInfo();
    }

    public final boolean equals(@CheckForNull Object o) {
        if (!(o instanceof ColumnSourceInfo)) {
            return false;
        }
        ColumnSourceInfo other = (ColumnSourceInfo)o;
        return this.startCol == other.getStartColumn() && this.endCol == other.getEndColumn() && this.lineSourceInfo.equals(other.lineSourceInfo);
    }

    @Nonnull
    public String toString() {
        return this.lineSourceInfo.getFileName() + ':' + this.getStartLine() + '.' + this.getStartColumn() + '-' + this.getEndLine() + '.' + this.getEndColumn();
    }

    public final int hashCode() {
        return this.lineSourceInfo.hashCode() + 29 * this.startCol + 31 * this.endCol;
    }
}

