/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.impl;

import com.android.jack.Jack;
import com.android.jack.ir.ast.CanBeAbstract;
import com.android.jack.ir.ast.CanBeFinal;
import com.android.jack.ir.ast.CanBeNative;
import com.android.jack.ir.ast.CanBeStatic;
import com.android.jack.ir.ast.HasName;
import com.android.jack.ir.ast.HasType;
import com.android.jack.ir.ast.JAbsentArrayDimension;
import com.android.jack.ir.ast.JAbstractMethodBody;
import com.android.jack.ir.ast.JAbstractStringLiteral;
import com.android.jack.ir.ast.JAlloc;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JAnnotationMethod;
import com.android.jack.ir.ast.JArrayLength;
import com.android.jack.ir.ast.JArrayLiteral;
import com.android.jack.ir.ast.JArrayRef;
import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JAssertStatement;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JBooleanLiteral;
import com.android.jack.ir.ast.JBreakStatement;
import com.android.jack.ir.ast.JByteLiteral;
import com.android.jack.ir.ast.JCaseStatement;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JCharLiteral;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassLiteral;
import com.android.jack.ir.ast.JConditionalExpression;
import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JContinueStatement;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JDoStatement;
import com.android.jack.ir.ast.JDoubleLiteral;
import com.android.jack.ir.ast.JDynamicCastOperation;
import com.android.jack.ir.ast.JEnumLiteral;
import com.android.jack.ir.ast.JExceptionRuntimeValue;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldInitializer;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JFloatLiteral;
import com.android.jack.ir.ast.JForStatement;
import com.android.jack.ir.ast.JGoto;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JInstanceOf;
import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JLabel;
import com.android.jack.ir.ast.JLabeledStatement;
import com.android.jack.ir.ast.JLambda;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JLock;
import com.android.jack.ir.ast.JLongLiteral;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdRef;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JModifier;
import com.android.jack.ir.ast.JMultiExpression;
import com.android.jack.ir.ast.JNameValuePair;
import com.android.jack.ir.ast.JNewArray;
import com.android.jack.ir.ast.JNewInstance;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.JNullType;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JParameterRef;
import com.android.jack.ir.ast.JPhantomClassOrInterface;
import com.android.jack.ir.ast.JPolymorphicMethodCall;
import com.android.jack.ir.ast.JPostfixOperation;
import com.android.jack.ir.ast.JPrefixOperation;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JReferenceType;
import com.android.jack.ir.ast.JReinterpretCastOperation;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JShortLiteral;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JSynchronizedBlock;
import com.android.jack.ir.ast.JThis;
import com.android.jack.ir.ast.JThisRef;
import com.android.jack.ir.ast.JThrowStatement;
import com.android.jack.ir.ast.JTryStatement;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JUnlock;
import com.android.jack.ir.ast.JWhileStatement;
import com.android.jack.ir.formatter.SourceFormatter;
import com.android.jack.ir.impl.JavaPrecedenceVisitor;
import com.android.jack.ir.impl.TextOutputVisitor;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.util.TextOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class BaseGenerationVisitor
extends TextOutputVisitor {
    static final char[] CHARS_ABSTRACT = "abstract ".toCharArray();
    static final char[] CHARS_ALLOC = "alloc ".toCharArray();
    static final char[] CHARS_ASSERT = "assert ".toCharArray();
    static final char[] CHARS_BREAK = "break".toCharArray();
    static final char[] CHARS_CASE = "case ".toCharArray();
    static final char[] CHARS_CATCH = " catch ".toCharArray();
    static final char[] CHARS_CLASS = "class ".toCharArray();
    static final char[] CHARS_COMMA = ", ".toCharArray();
    static final char[] CHARS_CONTINUE = "continue".toCharArray();
    static final char[] CHARS_DEFAULT = "default".toCharArray();
    static final char[] CHARS_DO = "do".toCharArray();
    static final char[] CHARS_DOTCLASS = ".class".toCharArray();
    static final char[] CHARS_ELSE = "else".toCharArray();
    static final char[] CHARS_MULTI_CATCH = "|".toCharArray();
    static final char[] CHARS_EXTENDS = "extends ".toCharArray();
    static final char[] CHARS_FALSE = "false".toCharArray();
    static final char[] CHARS_FINAL = "final ".toCharArray();
    static final char[] CHARS_FINALLY = " finally ".toCharArray();
    static final char[] CHARS_FOR = "for ".toCharArray();
    static final char[] CHARS_GOTO = "goto".toCharArray();
    static final char[] CHARS_IF = "if ".toCharArray();
    static final char[] CHARS_IMPLEMENTS = "implements ".toCharArray();
    static final char[] CHARS_INSTANCEOF = " instanceof ".toCharArray();
    static final char[] CHARS_INTERFACE = "interface ".toCharArray();
    static final char[] CHARS_NATIVE = "native ".toCharArray();
    static final char[] CHARS_NEW = "new ".toCharArray();
    static final char[] CHARS_NONAME = "no-name ".toCharArray();
    static final char[] CHARS_NULL = "null".toCharArray();
    static final char[] CHARS_PRIVATE = "private ".toCharArray();
    static final char[] CHARS_PUBLIC = "public ".toCharArray();
    static final char[] CHARS_REINTERPRETCAST = "reinterpret-cast ".toCharArray();
    static final char[] CHARS_RETURN = "return".toCharArray();
    static final char[] CHARS_RUNTIME_EXCEPTION = "Runtime exception of type".toCharArray();
    static final char[] CHARS_STATIC = "static ".toCharArray();
    static final char[] CHARS_SUPER = "super".toCharArray();
    static final char[] CHARS_SWITCH = "switch ".toCharArray();
    static final char[] CHARS_THIS = "this".toCharArray();
    static final char[] CHARS_THROW = "throw".toCharArray();
    static final char[] CHARS_TRUE = "true".toCharArray();
    static final char[] CHARS_TRY = "try ".toCharArray();
    static final char[] CHARS_WHILE = "while ".toCharArray();
    static final char[] SYNCHRONIZED_BLOCK = "synchronized ".toCharArray();
    static final char[] LOCK = "lock ".toCharArray();
    static final char[] UNLOCK = "unlock ".toCharArray();
    static final SourceFormatter formatter = SourceFormatter.getFormatter();
    protected boolean needSemi = true;
    protected boolean suppressType = false;

    public BaseGenerationVisitor(TextOutput textOutput) {
        super(textOutput);
    }

    @Override
    public boolean visit(@Nonnull JAbsentArrayDimension x) {
        return false;
    }

    @Override
    public boolean visit(@Nonnull JAnnotation annotation) {
        this.print("@");
        this.printTypeName(annotation.getType());
        this.lparen();
        ArrayList<JNameValuePair> nameValuePairs = new ArrayList<JNameValuePair>(annotation.getNameValuePairs());
        Collections.sort(nameValuePairs, new Comparator<JNameValuePair>(){

            @Override
            public int compare(JNameValuePair nameValuePair1, JNameValuePair nameValuePair2) {
                return nameValuePair1.getName().compareTo(nameValuePair2.getName());
            }
        });
        this.visitCollectionWithCommas(nameValuePairs.iterator());
        this.rparen();
        return false;
    }

    @Override
    public boolean visit(@Nonnull JArrayLength x) {
        JExpression instance = x.getInstance();
        this.parenPush(x, instance);
        this.accept(instance);
        this.parenPop(x, instance);
        this.print(".length");
        return false;
    }

    @Override
    public boolean visit(@Nonnull JArrayLiteral arrayLiteral) {
        List<JLiteral> values = arrayLiteral.getValues();
        if (values.size() > 1) {
            this.print('{');
        }
        this.visitCollectionWithCommas(values.iterator());
        if (values.size() > 1) {
            this.print('}');
        }
        return false;
    }

    @Override
    public boolean visit(@Nonnull JAlloc x) {
        this.print(CHARS_ALLOC);
        this.print("<");
        this.print(x.getType().getName());
        this.print(">");
        return false;
    }

    @Override
    public boolean visit(@Nonnull JArrayRef x) {
        JExpression instance = x.getInstance();
        this.parenPush(x, instance);
        this.accept(instance);
        this.parenPop(x, instance);
        this.print('[');
        this.accept(x.getIndexExpr());
        this.print(']');
        return false;
    }

    @Override
    public boolean visit(@Nonnull JArrayType x) {
        this.accept(x.getElementType());
        this.print("[]");
        return false;
    }

    @Override
    public boolean visit(@Nonnull JAssertStatement x) {
        this.print(CHARS_ASSERT);
        this.accept(x.getTestExpr());
        JExpression arg = x.getArg();
        if (arg != null) {
            this.print(" : ");
            this.accept(arg);
        }
        return false;
    }

    @Override
    public boolean visit(@Nonnull JBinaryOperation x) {
        JExpression arg1 = x.getLhs();
        this.parenPush(x, arg1);
        this.accept(arg1);
        this.parenPop(x, arg1);
        this.space();
        this.print(x.getOp().toString());
        this.space();
        JExpression arg2 = x.getRhs();
        this.parenPush(x, arg2);
        this.accept(arg2);
        this.parenPop(x, arg2);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JExceptionRuntimeValue x) {
        this.print(CHARS_RUNTIME_EXCEPTION);
        this.space();
        this.printTypeName(x.getType());
        return super.visit(x);
    }

    @Override
    public boolean visit(@Nonnull JCatchBlock x) {
        JLocal catchVar = x.getCatchVar();
        if (catchVar.getType().isSameType(Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_OBJECT))) {
            this.print(CHARS_FINALLY);
        } else {
            this.print(CHARS_CATCH);
            this.lparen();
            boolean first = true;
            for (JClass catchedType : x.getCatchTypes()) {
                if (first) {
                    first = false;
                } else {
                    this.space();
                    this.print(CHARS_MULTI_CATCH);
                    this.space();
                }
                this.printTypeName(catchedType);
            }
            this.space();
            this.printName(catchVar);
            this.rparen();
        }
        this.space();
        this.openBlock();
        for (JStatement statement : x.getStatements()) {
            this.needSemi = true;
            this.accept(statement);
            if (this.needSemi) {
                this.semi();
            }
            this.newline();
        }
        this.closeBlock();
        this.needSemi = false;
        return false;
    }

    @Override
    public boolean visit(@Nonnull JBlock x) {
        this.openBlock();
        for (JStatement statement : x.getStatements()) {
            this.needSemi = true;
            this.accept(statement);
            if (this.needSemi) {
                this.semi();
            }
            this.newline();
        }
        this.closeBlock();
        this.needSemi = false;
        return false;
    }

    @Override
    public boolean visit(@Nonnull JBooleanLiteral x) {
        this.printBooleanLiteral(x.getValue());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JBreakStatement x) {
        this.print(CHARS_BREAK);
        if (x.getLabel() != null) {
            this.space();
            this.accept(x.getLabel());
        }
        return false;
    }

    @Override
    public boolean visit(@Nonnull JByteLiteral x) {
        this.print(Byte.toString(x.getValue()));
        return false;
    }

    @Override
    public boolean visit(@Nonnull JCaseStatement x) {
        JLiteral caseExpr = x.getExpr();
        if (caseExpr != null) {
            this.print(CHARS_CASE);
            this.accept(caseExpr);
        } else {
            this.print(CHARS_DEFAULT);
        }
        this.print(':');
        this.space();
        this.needSemi = false;
        return false;
    }

    @Override
    public boolean visit(@Nonnull JReinterpretCastOperation x) {
        this.lparen();
        this.print(CHARS_REINTERPRETCAST);
        this.printType(x);
        this.rparen();
        this.space();
        JExpression expr = x.getExpr();
        this.parenPush(x, expr);
        this.accept(expr);
        this.parenPop(x, expr);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JDynamicCastOperation x) {
        this.lparen();
        Iterator<JType> typesIt = x.getTypes().iterator();
        this.printTypeName(typesIt.next());
        while (typesIt.hasNext()) {
            this.print(" & ");
            this.printTypeName(typesIt.next());
        }
        this.rparen();
        this.space();
        JExpression expr = x.getExpr();
        this.parenPush(x, expr);
        this.accept(expr);
        this.parenPop(x, expr);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JCharLiteral x) {
        this.printCharLiteral(x.getValue());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JClassLiteral x) {
        this.printTypeName(x.getRefType());
        this.print(CHARS_DOTCLASS);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JDefinedClass x) {
        this.printAnnotationLiterals(x.getAnnotations());
        this.printTypeFlags(x);
        this.print(CHARS_CLASS);
        this.printTypeName(x);
        this.space();
        JClass superClass = x.getSuperClass();
        if (superClass != null) {
            this.print(CHARS_EXTENDS);
            this.printTypeName(superClass);
            this.space();
        }
        if (x.getImplements().size() > 0) {
            this.print(CHARS_IMPLEMENTS);
            int c = x.getImplements().size();
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    this.print(CHARS_COMMA);
                }
                this.printTypeName(x.getImplements().get(i));
            }
            this.space();
        }
        return false;
    }

    @Override
    public boolean visit(@Nonnull JConditionalExpression x) {
        JExpression ifTest = x.getIfTest();
        this.parenPush(x, ifTest);
        this.accept(ifTest);
        this.parenPop(x, ifTest);
        this.print(" ? ");
        JExpression thenExpr = x.getThenExpr();
        this.parenPush(x, thenExpr);
        this.accept(thenExpr);
        this.parenPop(x, thenExpr);
        this.print(" : ");
        JExpression elseExpr = x.getElseExpr();
        this.parenPush(x, elseExpr);
        this.accept(elseExpr);
        this.parenPop(x, elseExpr);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JConstructor x) {
        this.printAnnotationLiterals(x.getAnnotations());
        if (x.isPrivate()) {
            this.print(CHARS_PRIVATE);
        } else {
            this.print(CHARS_PUBLIC);
        }
        this.printName(x);
        this.printParameterList(x);
        if (x.isAbstract() || !this.shouldPrintMethodBody()) {
            this.semi();
            this.newlineOpt();
        } else {
            JMethodBody body = x.getBody();
            assert (body != null);
            this.accept(body);
        }
        return false;
    }

    @Override
    public boolean visit(@Nonnull JContinueStatement x) {
        this.print(CHARS_CONTINUE);
        if (x.getLabel() != null) {
            this.space();
            this.accept(x.getLabel());
        }
        return false;
    }

    @Override
    public boolean visit(@Nonnull JFieldInitializer x) {
        if (!this.suppressType) {
            this.printName(x.getFieldRef().getFieldId());
        } else {
            this.accept(x.getFieldRef());
        }
        JExpression initializer = x.getInitializer();
        this.print(" = ");
        this.accept(initializer);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JDoStatement x) {
        this.print(CHARS_DO);
        if (x.getBody() != null) {
            this.nestedStatementPush(x.getBody());
            this.accept(x.getBody());
            this.nestedStatementPop(x.getBody());
        }
        if (this.needSemi) {
            this.semi();
            this.newline();
        } else {
            this.space();
            this.needSemi = true;
        }
        this.print(CHARS_WHILE);
        this.lparen();
        this.accept(x.getTestExpr());
        this.rparen();
        return false;
    }

    @Override
    public boolean visit(@Nonnull JDoubleLiteral x) {
        this.printDoubleLiteral(x.getValue());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JEnumLiteral enumLiteral) {
        this.printTypeName(enumLiteral.getType());
        this.print('.');
        this.print(enumLiteral.getFieldId().getName());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JExpressionStatement x) {
        this.accept(x.getExpr());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JField x) {
        this.printAnnotationLiterals(x.getAnnotations());
        this.print(JModifier.getStringFieldModifier(x.getModifier()));
        this.printType(x);
        this.space();
        this.printName(x);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JFieldRef x) {
        JExpression instance = x.getInstance();
        if (instance != null) {
            this.parenPush(x, instance);
            this.accept(instance);
            this.parenPop(x, instance);
        } else {
            this.printTypeName(x.getReceiverType());
        }
        this.print('.');
        this.printName(x.getFieldId());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JFloatLiteral x) {
        this.printFloatLiteral(x.getValue());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JForStatement x) {
        JStatement stmt;
        this.print(CHARS_FOR);
        this.lparen();
        Iterator<JStatement> iter = x.getInitializers().iterator();
        if (iter.hasNext()) {
            stmt = iter.next();
            this.accept(stmt);
        }
        this.suppressType = true;
        while (iter.hasNext()) {
            this.print(CHARS_COMMA);
            stmt = iter.next();
            this.accept(stmt);
        }
        this.suppressType = false;
        this.semi();
        this.space();
        if (x.getTestExpr() != null) {
            this.accept(x.getTestExpr());
        }
        this.semi();
        this.space();
        this.visitCollectionWithCommas(x.getIncrements().iterator());
        this.rparen();
        if (x.getBody() != null) {
            this.nestedStatementPush(x.getBody());
            this.accept(x.getBody());
            this.nestedStatementPop(x.getBody());
        }
        return false;
    }

    @Override
    public boolean visit(@Nonnull JGoto x) {
        this.print(CHARS_GOTO);
        this.space();
        this.accept(x.getTargetBlock().getLabel());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JIfStatement x) {
        this.print(CHARS_IF);
        this.lparen();
        this.accept(x.getIfExpr());
        this.rparen();
        if (x.getThenStmt() != null) {
            this.nestedStatementPush(x.getThenStmt());
            this.accept(x.getThenStmt());
            this.nestedStatementPop(x.getThenStmt());
        }
        if (x.getElseStmt() != null) {
            if (this.needSemi) {
                this.semi();
                this.newline();
            } else {
                this.space();
                this.needSemi = true;
            }
            this.print(CHARS_ELSE);
            boolean elseIf = x.getElseStmt() instanceof JIfStatement;
            if (!elseIf) {
                this.nestedStatementPush(x.getElseStmt());
            } else {
                this.space();
            }
            this.accept(x.getElseStmt());
            if (!elseIf) {
                this.nestedStatementPop(x.getElseStmt());
            }
        }
        return false;
    }

    @Override
    public boolean visit(@Nonnull JInstanceOf x) {
        JExpression expr = x.getExpr();
        this.parenPush(x, expr);
        this.accept(expr);
        this.parenPop(x, expr);
        this.print(CHARS_INSTANCEOF);
        this.printTypeName(x.getTestType());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JDefinedInterface x) {
        this.printAnnotationLiterals(x.getAnnotations());
        this.printTypeFlags(x);
        this.print(CHARS_INTERFACE);
        this.printTypeName(x);
        this.space();
        if (x.getImplements().size() > 0) {
            this.print(CHARS_EXTENDS);
            int c = x.getImplements().size();
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    this.print(CHARS_COMMA);
                }
                this.printTypeName(x.getImplements().get(i));
            }
            this.space();
        }
        return false;
    }

    @Override
    public boolean visit(@Nonnull JIntLiteral x) {
        this.print(Integer.toString(x.getValue()));
        return false;
    }

    @Override
    public boolean visit(@Nonnull JLabel x) {
        this.printName(x);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JLabeledStatement x) {
        this.accept(x.getLabel());
        this.print(" : ");
        this.accept(x.getBody());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JLambda x) {
        this.visitCollectionJType(x.getMethodIdWithoutErasure().getMethodIdWide().getParamTypes().iterator());
        this.print(" -> ");
        this.openBlock();
        this.print("SAM type: ");
        this.printType(x);
        this.newline();
        this.print("interface bounds: ");
        Iterator<JInterface> boundTypeIt = x.getInterfaceBounds().iterator();
        if (boundTypeIt.hasNext()) {
            this.printName(boundTypeIt.next());
        }
        while (boundTypeIt.hasNext()) {
            this.print(CHARS_COMMA);
            this.printName(boundTypeIt.next());
        }
        this.newline();
        this.print("captured variables: ");
        this.visitCollectionWithCommas(x.getCapturedVariables().iterator());
        this.newline();
        this.print("method to implement: ");
        this.printJMethodId(x.getMethodIdWithErasure());
        this.newline();
        this.print("method to enforce: ");
        this.printJMethodId(x.getMethodIdWithoutErasure());
        this.newline();
        this.print("lambda method: ");
        this.accept(x.getMethodIdRef());
        this.newline();
        this.print("bridges: ");
        this.visitCollectionJMethodId(x.getBridgeMethodIds().iterator());
        this.newline();
        this.closeBlock();
        return false;
    }

    protected void visitCollectionJMethodId(@Nonnull Iterator<JMethodId> iter) {
        if (iter.hasNext()) {
            this.printJMethodId(iter.next());
        }
        while (iter.hasNext()) {
            this.print(CHARS_COMMA);
            this.printJMethodId(iter.next());
        }
    }

    private void printJMethodId(@Nonnull JMethodId methodId) {
        this.printType(methodId);
        this.space();
        this.printName(methodId.getMethodIdWide());
        this.visitCollectionJType(methodId.getMethodIdWide().getParamTypes().iterator());
    }

    private void visitCollectionJType(@Nonnull Iterator<JType> iter) {
        this.lparen();
        if (iter.hasNext()) {
            this.printName(iter.next());
        }
        while (iter.hasNext()) {
            this.print(CHARS_COMMA);
            this.printName(iter.next());
        }
        this.rparen();
    }

    @Override
    public boolean visit(@Nonnull JLocal x) {
        this.printAnnotationLiterals(x.getAnnotations());
        this.printFinalFlag(x);
        this.printType(x);
        this.space();
        this.printName(x);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JLocalRef x) {
        this.printName(x.getLocal());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JLongLiteral x) {
        this.printLongLiteral(x.getValue());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JMethod x) {
        this.printMethodHeader(x);
        if (x instanceof JAnnotationMethod) {
            JLiteral defaultValue = ((JAnnotationMethod)x).getDefaultValue();
            if (defaultValue != null) {
                this.space();
                this.print(CHARS_DEFAULT);
                this.space();
                this.accept(defaultValue);
                this.semi();
                this.newlineOpt();
            }
        } else if (x.isAbstract() || !this.shouldPrintMethodBody()) {
            this.semi();
            this.newlineOpt();
        } else {
            this.space();
            JAbstractMethodBody body = x.getBody();
            assert (body != null);
            this.accept(body);
        }
        return false;
    }

    @Override
    public boolean visit(@Nonnull JMethodBody x) {
        this.accept(x.getBlock());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JMethodIdRef x) {
        this.printTypeName(x.getEnclosingType());
        this.print('.');
        this.printName(x.getMethodId().getMethodIdWide());
        this.visitCollectionJType(x.getMethodId().getMethodIdWide().getParamTypes().iterator());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JPolymorphicMethodCall x) {
        JExpression instance = x.getInstance();
        assert (instance != null);
        JMethodIdWide target = x.getMethodId();
        if (x.getInstance() instanceof JThisRef) {
            this.print(CHARS_THIS);
        } else {
            this.parenPush(x, instance);
            this.accept(instance);
            this.parenPop(x, instance);
            this.print('.');
            this.printName(target);
        }
        this.lparen();
        this.visitCollectionWithCommas(x.getArgs().iterator());
        this.rparen();
        return false;
    }

    @Override
    public boolean visit(@Nonnull JMethodCall x) {
        JExpression instance = x.getInstance();
        JMethodIdWide target = x.getMethodId();
        if (instance == null) {
            this.printTypeName(x.getReceiverType());
            this.print('.');
            this.printName(target);
        } else if (x.getInstance() instanceof JThisRef) {
            JReferenceType thisType = (JReferenceType)instance.getType();
            if (thisType.isSameType(x.getReceiverType())) {
                this.print(CHARS_THIS);
            } else {
                this.print(CHARS_SUPER);
            }
            if (!(x instanceof JNewInstance)) {
                this.print('.');
                this.printName(target);
            }
        } else {
            this.parenPush(x, instance);
            this.accept(instance);
            this.parenPop(x, instance);
            this.print('.');
            this.printName(target);
        }
        this.lparen();
        this.visitCollectionWithCommas(x.getArgs().iterator());
        this.rparen();
        return false;
    }

    @Override
    public boolean visit(@Nonnull JMultiExpression x) {
        this.lparen();
        this.visitCollectionWithCommas(x.exprs.iterator());
        this.rparen();
        return false;
    }

    @Override
    public boolean visit(@Nonnull JNameValuePair nameValuePair) {
        this.print(nameValuePair.getName());
        this.print(" = ");
        this.accept(nameValuePair.getValue());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JNewArray x) {
        this.print(CHARS_NEW);
        List<JExpression> initializers = x.getInitializers();
        boolean hasInitializer = initializers.isEmpty();
        this.printTypeName(!hasInitializer ? x.getArrayType() : x.getArrayType().getLeafType());
        if (!hasInitializer) {
            this.print("{");
            this.visitCollectionWithCommas(initializers.iterator());
            this.print('}');
        } else {
            List<JExpression> dims = x.getDims();
            for (int i = 0; i < dims.size(); ++i) {
                JExpression expr = dims.get(i);
                this.print('[');
                this.accept(expr);
                this.print(']');
            }
        }
        return false;
    }

    @Override
    public boolean visit(@Nonnull JNewInstance x) {
        this.print(CHARS_NEW);
        JMethodIdWide target = x.getMethodId();
        this.printName(target);
        this.lparen();
        this.visitCollectionWithCommas(x.getArgs().iterator());
        this.rparen();
        return false;
    }

    @Override
    public boolean visit(@Nonnull JNullLiteral x) {
        this.print(CHARS_NULL);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JNullType x) {
        this.printTypeName(x);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JPackage pack) {
        this.print(formatter.getName(pack));
        return false;
    }

    @Override
    public boolean visit(@Nonnull JParameter x) {
        this.printAnnotationLiterals(x.getAnnotations());
        this.print(JModifier.getStringVariableModifier(x.getModifier()));
        this.printType(x);
        this.space();
        this.printName(x);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JParameterRef x) {
        this.printName(x.getTarget());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JPhantomClassOrInterface x) {
        this.printTypeName(x);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JPostfixOperation x) {
        JExpression arg = x.getArg();
        this.parenPush(x, arg);
        this.accept(arg);
        this.parenPop(x, arg);
        this.print(x.getOp().toString());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JPrefixOperation x) {
        this.print(x.getOp().toString());
        JExpression arg = x.getArg();
        this.parenPush(x, arg);
        this.accept(arg);
        this.parenPop(x, arg);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JPrimitiveType x) {
        this.printTypeName(x);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JSession x) {
        this.print("<JSession>");
        return false;
    }

    @Override
    public boolean visit(@Nonnull JReturnStatement x) {
        this.print(CHARS_RETURN);
        JExpression expr = x.getExpr();
        if (expr != null) {
            this.space();
            this.accept(expr);
        }
        return false;
    }

    @Override
    public boolean visit(@Nonnull JShortLiteral x) {
        this.print(Short.toString(x.getValue()));
        return false;
    }

    @Override
    public boolean visit(@Nonnull JAbstractStringLiteral x) {
        this.printStringLiteral(x.getValue());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JSwitchStatement x) {
        this.print(CHARS_SWITCH);
        this.lparen();
        this.accept(x.getExpr());
        this.rparen();
        this.space();
        this.nestedStatementPush(x.getBody());
        this.accept(x.getBody());
        this.nestedStatementPop(x.getBody());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JThis x) {
        this.printType(x);
        this.space();
        this.printName(x);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JThisRef x) {
        this.printName(x.getTarget());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JThrowStatement x) {
        this.print(CHARS_THROW);
        if (x.getExpr() != null) {
            this.space();
            this.accept(x.getExpr());
        }
        return false;
    }

    @Override
    public boolean visit(@Nonnull JTryStatement x) {
        this.print(CHARS_TRY);
        this.accept(x.getTryBlock());
        for (JCatchBlock catchBlock : x.getCatchBlocks()) {
            this.accept(catchBlock);
        }
        JBlock finallyBlock = x.getFinallyBlock();
        if (finallyBlock != null) {
            this.print(CHARS_FINALLY);
            this.accept(finallyBlock);
        }
        return false;
    }

    @Override
    public boolean visit(@Nonnull JWhileStatement x) {
        this.print(CHARS_WHILE);
        this.lparen();
        this.accept(x.getTestExpr());
        this.rparen();
        if (x.getBody() != null) {
            this.nestedStatementPush(x.getBody());
            this.accept(x.getBody());
            this.nestedStatementPop(x.getBody());
        }
        return false;
    }

    @Override
    public boolean visit(@Nonnull JLock x) {
        this.print(LOCK);
        this.lparen();
        this.accept(x.getLockExpr());
        this.rparen();
        return false;
    }

    @Override
    public boolean visit(@Nonnull JUnlock x) {
        this.print(UNLOCK);
        this.lparen();
        this.accept(x.getLockExpr());
        this.rparen();
        return false;
    }

    @Override
    public boolean visit(@Nonnull JSynchronizedBlock x) {
        this.print(SYNCHRONIZED_BLOCK);
        this.lparen();
        this.accept(x.getLockExpr());
        this.rparen();
        this.space();
        this.accept(x.getSynchronizedBlock());
        return false;
    }

    protected void closeBlock() {
        this.indentOut();
        this.print('}');
    }

    protected void lparen() {
        this.print('(');
    }

    protected void nestedStatementPop(JStatement statement) {
        if (!(statement instanceof JBlock)) {
            this.indentOut();
        }
    }

    protected void nestedStatementPush(JStatement statement) {
        if (!(statement instanceof JBlock)) {
            this.indentIn();
            this.newline();
        } else {
            this.space();
        }
    }

    protected void openBlock() {
        this.print('{');
        this.indentIn();
        this.newline();
    }

    protected boolean parenPop(int parentPrec, JExpression child) {
        int childPrec = JavaPrecedenceVisitor.exec(child);
        if (parentPrec < childPrec) {
            this.rparen();
            return true;
        }
        return false;
    }

    protected boolean parenPop(JExpression parent, JExpression child) {
        return this.parenPop(JavaPrecedenceVisitor.exec(parent), child);
    }

    protected boolean parenPush(int parentPrec, JExpression child) {
        int childPrec = JavaPrecedenceVisitor.exec(child);
        if (parentPrec < childPrec) {
            this.lparen();
            return true;
        }
        return false;
    }

    protected boolean parenPush(JExpression parent, JExpression child) {
        return this.parenPush(JavaPrecedenceVisitor.exec(parent), child);
    }

    protected void printTypeFlags(JDefinedClassOrInterface declaredType) {
        int modifier = declaredType.getModifier();
        String modifierStr = JModifier.getStringTypeModifier(modifier);
        this.print(modifierStr);
    }

    protected void printAbstractFlag(CanBeAbstract x) {
        if (x.isAbstract()) {
            this.print(CHARS_ABSTRACT);
        }
    }

    protected void printBooleanLiteral(boolean value) {
        this.print(value ? CHARS_TRUE : CHARS_FALSE);
    }

    protected void printChar(char c) {
        switch (c) {
            case '\b': {
                this.print("\\b");
                break;
            }
            case '\t': {
                this.print("\\t");
                break;
            }
            case '\n': {
                this.print("\\n");
                break;
            }
            case '\f': {
                this.print("\\f");
                break;
            }
            case '\r': {
                this.print("\\r");
                break;
            }
            case '\"': {
                this.print("\\\"");
                break;
            }
            case '\'': {
                this.print("\\'");
                break;
            }
            case '\\': {
                this.print("\\\\");
                break;
            }
            default: {
                if (Character.isISOControl(c)) {
                    this.print("\\u");
                    if (c < '\u1000') {
                        this.print('0');
                    }
                    if (c < '\u0100') {
                        this.print('0');
                    }
                    if (c < '\u0010') {
                        this.print('0');
                    }
                    this.print(Integer.toHexString(c));
                    break;
                }
                this.print(c);
            }
        }
    }

    protected void printCharLiteral(char value) {
        this.print('\'');
        this.printChar(value);
        this.print('\'');
    }

    protected void printDoubleLiteral(double value) {
        this.print(Double.toString(value));
    }

    protected void printFinalFlag(CanBeFinal x) {
        if (x.isFinal()) {
            this.print(CHARS_FINAL);
        }
    }

    protected void printFloatLiteral(float value) {
        this.print(Float.toString(value));
        this.print('f');
    }

    protected void printLongLiteral(long value) {
        this.print(Long.toString(value));
        this.print('L');
    }

    protected void printMethodHeader(JMethod x) {
        this.printAnnotationLiterals(x.getAnnotations());
        this.print(JModifier.getStringMethodModifier(x.getModifier()));
        this.printType(x);
        this.space();
        this.printName(x);
        this.printParameterList(x);
    }

    private void printAnnotationLiterals(Collection<JAnnotation> annotation) {
        ArrayList<JAnnotation> annotations = new ArrayList<JAnnotation>(annotation);
        Collections.sort(annotations, new Comparator<JAnnotation>(){

            @Override
            public int compare(JAnnotation annotation1, JAnnotation annotation2) {
                return Jack.getLookupFormatter().getName(annotation1.getType()).compareTo(Jack.getLookupFormatter().getName(annotation2.getType()));
            }
        });
        for (JAnnotation annotationLiteral : annotations) {
            this.accept(annotationLiteral);
            this.space();
        }
    }

    protected void printName(HasName x) {
        String name = x.getName();
        if (name == null) {
            this.print(CHARS_NONAME);
        } else {
            this.print(name.replace('/', '.'));
        }
    }

    protected void printNativeFlag(CanBeNative x) {
        if (x.isNative()) {
            this.print(CHARS_NATIVE);
        }
    }

    protected void printParameterList(JMethod x) {
        this.lparen();
        this.visitCollectionWithCommas(x.getParams().iterator());
        this.rparen();
    }

    protected void printStaticFlag(CanBeStatic x) {
        if (x.isStatic()) {
            this.print(CHARS_STATIC);
        }
    }

    protected void printStringLiteral(String string) {
        char[] s = string.toCharArray();
        this.print('\"');
        for (int i = 0; i < s.length; ++i) {
            this.printChar(s[i]);
        }
        this.print('\"');
    }

    protected void printType(HasType hasType) {
        this.printTypeName(hasType.getType());
    }

    protected void printTypeName(JType type) {
        this.print(formatter.getName(type));
    }

    protected void rparen() {
        this.print(')');
    }

    protected void semi() {
        this.print(';');
    }

    protected boolean shouldPrintMethodBody() {
        return false;
    }

    protected void space() {
        this.print(' ');
    }

    protected void visitCollectionWithCommas(Iterator<? extends JNode> iter) {
        if (iter.hasNext()) {
            this.accept(iter.next());
        }
        while (iter.hasNext()) {
            this.print(CHARS_COMMA);
            this.accept(iter.next());
        }
    }
}

