/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.formatter;

import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JNullType;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.formatter.CharSeparatedPackageFormatter;
import com.android.jack.ir.formatter.TypePackageAndMethodFormatter;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class SourceFormatter
extends CharSeparatedPackageFormatter
implements TypePackageAndMethodFormatter {
    @Nonnull
    private static final SourceFormatter formatter = new SourceFormatter();

    protected SourceFormatter() {
    }

    @Override
    protected char getPackageSeparator() {
        return '.';
    }

    @Nonnull
    public static SourceFormatter getFormatter() {
        return formatter;
    }

    @Override
    @Nonnull
    public String getName(@Nonnull JType type) {
        if (type instanceof JClassOrInterface) {
            return this.getClassOrInterfaceName((JClassOrInterface)type);
        }
        if (type instanceof JArrayType) {
            return this.getName(((JArrayType)type).getElementType()) + "[]";
        }
        if (type instanceof JNullType) {
            return "null";
        }
        if (type instanceof JPrimitiveType) {
            switch (((JPrimitiveType)type).getPrimitiveTypeEnum()) {
                case BOOLEAN: {
                    return "boolean";
                }
                case BYTE: {
                    return "byte";
                }
                case CHAR: {
                    return "char";
                }
                case DOUBLE: {
                    return "double";
                }
                case FLOAT: {
                    return "float";
                }
                case INT: {
                    return "int";
                }
                case LONG: {
                    return "long";
                }
                case SHORT: {
                    return "short";
                }
                case VOID: {
                    return "void";
                }
            }
            throw new AssertionError();
        }
        throw new AssertionError();
    }

    @Nonnull
    private String getClassOrInterfaceName(@Nonnull JClassOrInterface type) {
        JPackage enclosingPackage = type.getEnclosingPackage();
        assert (enclosingPackage != null);
        return this.getName(enclosingPackage, type.getName());
    }

    @Override
    @Nonnull
    public String getName(@Nonnull JPackage enclosingPackage, @Nonnull String classOrInterfaceSimpleName) {
        StringBuilder sb;
        if (!enclosingPackage.isDefaultPackage()) {
            sb = this.getNameInternal(enclosingPackage);
            sb.append(this.getPackageSeparator());
        } else {
            sb = new StringBuilder();
        }
        sb.append(classOrInterfaceSimpleName);
        return sb.toString();
    }

    @Override
    @Nonnull
    public String getName(@Nonnull JPackage pack) {
        return this.getNameInternal(pack).toString();
    }

    @Override
    @Nonnull
    public String getName(@Nonnull JMethod method) {
        StringBuilder sb = new StringBuilder(this.getName(method.getType()));
        sb.append(' ');
        sb.append(method.getName());
        sb.append('(');
        Iterator<JParameter> argumentIterator = method.getParams().iterator();
        while (argumentIterator.hasNext()) {
            JParameter argument = argumentIterator.next();
            sb.append(this.getName(argument.getType()));
            sb.append(' ');
            sb.append(argument.getName());
            if (!argumentIterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    @Nonnull
    public String getName(@Nonnull String methodName, @Nonnull List<? extends JType> argumentTypes, @Nonnull JType returnType) {
        return this.getName(returnType) + ' ' + this.getNameWithoutReturnType(methodName, argumentTypes);
    }

    @Override
    @Nonnull
    public String getNameWithoutReturnType(@Nonnull JMethodIdWide methodId) {
        return this.getNameWithoutReturnType(methodId.getName(), methodId.getParamTypes());
    }

    @Override
    @Nonnull
    public String getNameWithoutReturnType(@Nonnull String methodName, @Nonnull List<? extends JType> argumentTypes) {
        StringBuilder sb = new StringBuilder(methodName);
        sb.append('(');
        Iterator<? extends JType> argumentIterator = argumentTypes.iterator();
        while (argumentIterator.hasNext()) {
            sb.append(this.getName(argumentIterator.next()));
            if (!argumentIterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(')');
        return sb.toString();
    }
}

