/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.formatter;

import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JNullType;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.formatter.CharSeparatedPackageFormatter;
import com.android.jack.ir.formatter.PackageFormatter;
import com.android.jack.ir.formatter.TypeFormatter;
import javax.annotation.Nonnull;

public class BinaryQualifiedNameFormatter
extends CharSeparatedPackageFormatter
implements TypeFormatter,
PackageFormatter {
    @Nonnull
    private static final BinaryQualifiedNameFormatter formatter = new BinaryQualifiedNameFormatter();

    protected BinaryQualifiedNameFormatter() {
    }

    @Override
    protected char getPackageSeparator() {
        return '/';
    }

    @Nonnull
    public static BinaryQualifiedNameFormatter getFormatter() {
        return formatter;
    }

    @Override
    @Nonnull
    public String getName(@Nonnull JType type) {
        if (type instanceof JClassOrInterface) {
            return this.getClassOrInterfaceName((JClassOrInterface)type);
        }
        if (type instanceof JArrayType) {
            return this.getName(((JArrayType)type).getElementType()) + "[]";
        }
        if (type instanceof JNullType) {
            return "null";
        }
        if (type instanceof JPrimitiveType) {
            switch (((JPrimitiveType)type).getPrimitiveTypeEnum()) {
                case BOOLEAN: {
                    return "boolean";
                }
                case BYTE: {
                    return "byte";
                }
                case CHAR: {
                    return "char";
                }
                case DOUBLE: {
                    return "double";
                }
                case FLOAT: {
                    return "float";
                }
                case INT: {
                    return "int";
                }
                case LONG: {
                    return "long";
                }
                case SHORT: {
                    return "short";
                }
                case VOID: {
                    return "void";
                }
            }
            throw new AssertionError();
        }
        throw new AssertionError();
    }

    @Nonnull
    private String getClassOrInterfaceName(@Nonnull JClassOrInterface type) {
        JPackage enclosingPackage = type.getEnclosingPackage();
        assert (enclosingPackage != null);
        return this.getName(enclosingPackage, type.getName());
    }

    @Override
    @Nonnull
    public String getName(@Nonnull JPackage pack) {
        return this.getNameInternal(pack).toString();
    }

    @Override
    @Nonnull
    public String getName(@Nonnull JPackage enclosingPackage, @Nonnull String classOrInterfaceSimpleName) {
        StringBuilder sb;
        if (!enclosingPackage.isDefaultPackage()) {
            sb = this.getNameInternal(enclosingPackage);
            sb.append(this.getPackageSeparator());
        } else {
            sb = new StringBuilder();
        }
        sb.append(classOrInterfaceSimpleName);
        return sb.toString();
    }
}

