/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.item.Tag;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Java try statement")
public class JTryStatement
extends JStatement {
    @Nonnull
    private List<JStatement> resourcesDeclaration;
    @Nonnull
    private final List<JCatchBlock> catchBlocks;
    @CheckForNull
    private JBlock finallyBlock;
    @Nonnull
    private JBlock tryBlock;

    public JTryStatement(SourceInfo info, @Nonnull List<JStatement> resourcesDeclaration, @Nonnull JBlock tryBlock, @Nonnull List<JCatchBlock> catchBlocks, @CheckForNull JBlock finallyBlock) {
        super(info);
        this.resourcesDeclaration = resourcesDeclaration;
        this.tryBlock = tryBlock;
        this.catchBlocks = catchBlocks;
        this.finallyBlock = finallyBlock;
    }

    @Nonnull
    public List<JCatchBlock> getCatchBlocks() {
        return this.catchBlocks;
    }

    @CheckForNull
    public JBlock getFinallyBlock() {
        return this.finallyBlock;
    }

    @Nonnull
    public JBlock getTryBlock() {
        return this.tryBlock;
    }

    @Nonnull
    public List<JStatement> getResourcesDeclarations() {
        return this.resourcesDeclaration;
    }

    public void setResourcesDeclarations(@Nonnull List<JStatement> resourcesDeclaration) {
        this.resourcesDeclaration = resourcesDeclaration;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            visitor.accept(this.resourcesDeclaration);
            visitor.accept(this.tryBlock);
            visitor.accept(this.catchBlocks);
            if (this.finallyBlock != null) {
                visitor.accept(this.finallyBlock);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        for (JStatement stmt : this.resourcesDeclaration) {
            stmt.traverse(schedule);
        }
        this.tryBlock.traverse(schedule);
        for (JCatchBlock block : this.catchBlocks) {
            block.traverse(schedule);
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.traverse(schedule);
        }
    }

    @Override
    protected void transform(@Nonnull JNode existingNode, @CheckForNull JNode newNode, @Nonnull JNode.Transformation transformation) throws UnsupportedOperationException {
        if (!JTryStatement.transform(this.resourcesDeclaration, existingNode, (JStatement)newNode, transformation) && !JTryStatement.transform(this.catchBlocks, existingNode, (JCatchBlock)newNode, transformation)) {
            super.transform(existingNode, newNode, transformation);
        }
    }

    @Override
    protected void replaceImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException {
        assert (newNode != null);
        if (this.tryBlock == existingNode) {
            this.tryBlock = (JBlock)newNode;
        } else if (this.finallyBlock == existingNode) {
            this.finallyBlock = (JBlock)newNode;
        } else {
            super.replaceImpl(existingNode, newNode);
        }
    }

    @Override
    protected void removeImpl(@Nonnull JNode existingNode) throws UnsupportedOperationException {
        if (this.finallyBlock == existingNode) {
            this.finallyBlock = null;
        } else {
            super.removeImpl(existingNode);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Description(value="A JTryStatement is in try-with-resources form.")
    public static final class TryWithResourcesForm
    implements Tag {
    }

    @Description(value="A JTryStatement may contain a finally block.")
    public static final class FinallyBlock
    implements Tag {
    }
}

