/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.ast.HasEnclosingMethod;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JThisRef;
import com.android.jack.ir.ast.JVariable;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.Nonnull;

@Description(value="Java this variable definition")
public class JThis
extends JVariable
implements HasEnclosingMethod {
    @Nonnull
    private final JMethod enclosingMethod;

    public JThis(@Nonnull JMethod enclosingMethod) {
        super(SourceInfo.UNKNOWN, "this", enclosingMethod.getEnclosingType(), 0);
        assert (JMethod.needThis(enclosingMethod.getModifier()));
        this.enclosingMethod = enclosingMethod;
    }

    @Override
    @Nonnull
    public JMethod getEnclosingMethod() {
        return this.enclosingMethod;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            // empty if block
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        for (JAnnotation annotation : this.annotations) {
            annotation.traverse(schedule);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Override
    public void checkValidity() {
        if (!(this.parent instanceof JMethod)) {
            throw new JNodeInternalError(this, "Invalid parent");
        }
    }

    @Override
    @Nonnull
    public JThisRef makeRef(@Nonnull SourceInfo info) {
        return new JThisRef(info, this);
    }
}

