/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JSynchronize;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.Nonnull;

@Description(value="A synchronized block")
public class JSynchronizedBlock
extends JSynchronize {
    @Nonnull
    private JBlock synchronizedBlock;

    public JSynchronizedBlock(@Nonnull SourceInfo info, @Nonnull JExpression lockExpr, @Nonnull JBlock synchronizedBlock) {
        super(info, lockExpr);
        this.synchronizedBlock = synchronizedBlock;
    }

    @Nonnull
    public JBlock getSynchronizedBlock() {
        return this.synchronizedBlock;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            super.traverse(visitor);
            visitor.accept(this.synchronizedBlock);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        super.traverse(schedule);
        this.synchronizedBlock.traverse(schedule);
    }

    @Override
    protected void replaceImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException {
        assert (newNode != null);
        if (this.synchronizedBlock == existingNode) {
            this.synchronizedBlock = (JBlock)newNode;
        } else {
            super.replaceImpl(existingNode, newNode);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }
}

