/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.Jack;
import com.android.jack.ir.StringInterner;
import com.android.jack.ir.ast.CanBeRenamed;
import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JReferenceType;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.lookup.CommonTypes;
import com.android.sched.item.Description;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Reference type")
abstract class JReferenceTypeCommon
extends JNode
implements JReferenceType,
CanBeRenamed {
    @Nonnull
    protected String name;
    @CheckForNull
    private JArrayType array;

    public JReferenceTypeCommon(@Nonnull SourceInfo info, @Nonnull String name) {
        super(info);
        this.name = StringInterner.get().intern(name);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@Nonnull String name) {
        this.name = StringInterner.get().intern(name);
        assert (Jack.getSession().getPhantomLookup().check(this));
    }

    @Override
    @Nonnull
    public JExpression createDefaultValue(@Nonnull SourceInfo sourceInfo) {
        return new JNullLiteral(sourceInfo);
    }

    protected boolean isTrivialCast(@Nonnull JReferenceType castTo) {
        return this.isSameType(castTo) || castTo.isSameType(Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_OBJECT));
    }

    @CheckForNull
    protected static JPrimitiveType getWrappedType(@Nonnull JClassOrInterface type) {
        for (JPrimitiveType.JPrimitiveTypeEnum primitiveType : JPrimitiveType.JPrimitiveTypeEnum.values()) {
            if (!primitiveType.getType().isWrapperType(type)) continue;
            return primitiveType.getType();
        }
        return null;
    }

    @Override
    @Nonnull
    public JArrayType getArray() {
        if (this.array == null) {
            this.array = new JArrayType(this);
        }
        assert (this.array != null);
        return this.array;
    }
}

