/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.ast.FieldKind;
import com.android.jack.ir.ast.HasEnclosingPackage;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JFieldId;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JReferenceType;
import com.android.jack.ir.ast.JReferenceTypeCommon;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.util.NamingTools;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Phantom class or interface")
public class JPhantomClassOrInterface
extends JReferenceTypeCommon
implements JClassOrInterface {
    @Nonnull
    private JPackage enclosingPackage;
    @Nonnull
    private final List<JFieldId> fields = new ArrayList<JFieldId>();
    @Nonnull
    private final List<JMethodIdWide> methodIdsWide = new ArrayList<JMethodIdWide>();
    @Nonnull
    private final List<JMethodId> methodIds = new ArrayList<JMethodId>();

    public JPhantomClassOrInterface(@Nonnull String name, @Nonnull JPackage enclosingPackage) {
        super(SourceInfo.UNKNOWN, name);
        assert (NamingTools.isTypeIdentifier(name));
        this.enclosingPackage = enclosingPackage;
    }

    @Override
    @Nonnull
    public JPackage getEnclosingPackage() {
        return this.enclosingPackage;
    }

    @Override
    public void setEnclosingPackage(@CheckForNull JPackage enclosingPackage) {
        assert (enclosingPackage != null);
        this.enclosingPackage = enclosingPackage;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            // empty if block
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Override
    @CheckForNull
    public JPrimitiveType getWrappedType() {
        return JPhantomClassOrInterface.getWrappedType(this);
    }

    @Override
    public boolean isToEmit() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public JFieldId getOrCreateFieldId(@Nonnull String name, @Nonnull JType type, @Nonnull FieldKind kind) {
        List<JFieldId> list = this.fields;
        synchronized (list) {
            for (JFieldId field : this.fields) {
                if (!field.equals(name, type, kind)) continue;
                return field;
            }
            JFieldId newField = new JFieldId(name, type, kind);
            this.fields.add(newField);
            return newField;
        }
    }

    @Override
    @Nonnull
    public JFieldId getFieldId(@Nonnull String name, @Nonnull JType type, @Nonnull FieldKind kind) {
        return this.getOrCreateFieldId(name, type, kind);
    }

    @Override
    public boolean canBeSafelyUpcast(@Nonnull JReferenceType castTo) {
        return this.isTrivialCast(castTo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public JMethodIdWide getMethodIdWide(@Nonnull String name, @Nonnull List<? extends JType> argsType, @Nonnull MethodKind kind) {
        List<JMethodIdWide> list = this.methodIdsWide;
        synchronized (list) {
            for (JMethodIdWide id : this.methodIdsWide) {
                if (!id.equals(name, argsType, kind)) continue;
                return id;
            }
            JMethodIdWide newMethod = new JMethodIdWide(name, argsType, kind);
            this.methodIdsWide.add(newMethod);
            return newMethod;
        }
    }

    @Override
    @Nonnull
    public JMethodIdWide getOrCreateMethodIdWide(@Nonnull String name, @Nonnull List<? extends JType> argsType, @Nonnull MethodKind kind) {
        return this.getMethodIdWide(name, argsType, kind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public JMethodId getMethodId(@Nonnull String name, @Nonnull List<? extends JType> argsType, @Nonnull MethodKind kind, @Nonnull JType returnType) {
        List<JMethodIdWide> list = this.methodIdsWide;
        synchronized (list) {
            for (JMethodId id : this.methodIds) {
                if (!id.getType().equals(returnType) || !id.getMethodIdWide().equals(name, argsType, kind)) continue;
                return id;
            }
            JMethodId newMethod = new JMethodId(this.getOrCreateMethodIdWide(name, argsType, kind), returnType);
            this.methodIds.add(newMethod);
            return newMethod;
        }
    }

    @Override
    @Nonnull
    public JMethodId getOrCreateMethodId(@Nonnull String name, @Nonnull List<? extends JType> argsType, @Nonnull MethodKind kind, @Nonnull JType returnType) {
        return this.getMethodId(name, argsType, kind, returnType);
    }

    @Override
    public final boolean isSameType(@Nonnull JType type) {
        if (type instanceof HasEnclosingPackage) {
            return this.getEnclosingPackage() == ((HasEnclosingPackage)((Object)type)).getEnclosingPackage() && this.name.equals(type.getName());
        }
        return false;
    }

    @Override
    public void checkValidity() {
        if (!(this.parent instanceof JPackage)) {
            throw new JNodeInternalError(this, "Invalid parent");
        }
    }

    @Override
    public void setName(@Nonnull String name) {
        this.enclosingPackage.removeItemWithName(this);
        super.setName(name);
    }
}

