/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.StringInterner;
import com.android.jack.ir.ast.HasName;
import com.android.jack.ir.ast.JBreakStatement;
import com.android.jack.ir.ast.JContinueStatement;
import com.android.jack.ir.ast.JLabeledStatement;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.Nonnull;

@Description(value="Represents a Java label")
public class JLabel
extends JNode
implements HasName {
    private final String name;

    public JLabel(SourceInfo info, String name) {
        super(info);
        this.name = StringInterner.get().intern(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            // empty if block
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Override
    public void checkValidity() {
        if (!(this.parent instanceof JLabeledStatement || this.parent instanceof JBreakStatement || this.parent instanceof JContinueStatement)) {
            throw new JNodeInternalError(this, "Invalid parent");
        }
    }
}

