/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JEnum;
import com.android.jack.ir.ast.JEnumField;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JModifier;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.load.ClassOrInterfaceLoader;
import com.android.sched.item.Description;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Java enum type reference expression")
public class JDefinedEnum
extends JDefinedClass
implements JEnum {
    @Nonnull
    private final List<JEnumField> enumList = new ArrayList<JEnumField>();
    private boolean hasOrdinal = true;

    public JDefinedEnum(@Nonnull SourceInfo info, @Nonnull String name, int modifier, @Nonnull JPackage enclosingPackage, @Nonnull ClassOrInterfaceLoader loader) {
        super(info, name, modifier, enclosingPackage, loader);
        assert (JModifier.isEnum(modifier));
    }

    @Override
    public void addField(@Nonnull JField field) {
        if (field instanceof JEnumField && this.hasOrdinal) {
            JEnumField enumField = (JEnumField)field;
            int ordinal = enumField.ordinal();
            if (ordinal == -1) {
                this.hasOrdinal = false;
                this.enumList.clear();
            } else {
                while (ordinal >= this.enumList.size()) {
                    this.enumList.add(null);
                }
                this.enumList.set(ordinal, enumField);
            }
        }
        super.addField(field);
    }

    @Nonnull
    public List<JEnumField> getEnumList() {
        this.loader.ensureFields(this);
        assert (this.hasOrdinal);
        return this.enumList;
    }
}

