/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JBinaryOperator;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JReferenceType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Description;
import com.android.sched.transform.TransformRequest;
import javax.annotation.Nonnull;

@Description(value="Concat operator expression")
public class JConcatOperation
extends JBinaryOperation {
    @Nonnull
    private final JClass jlString;

    public JConcatOperation(@Nonnull SourceInfo info, @Nonnull JClass jlString, @Nonnull JExpression lhs, @Nonnull JExpression rhs) {
        super(info, lhs, rhs);
        this.jlString = jlString;
    }

    @Override
    @Nonnull
    public JType getType() {
        assert (this.hasValidOperand());
        return this.jlString;
    }

    private boolean hasValidOperand() {
        JType lhsType = this.getLhs().getType();
        JType rhsType = this.getRhs().getType();
        return lhsType.isSameType(this.jlString) && rhsType.isSameType(this.jlString) || lhsType.isSameType(this.jlString) && (rhsType == JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType() || rhsType == JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType() || rhsType == JPrimitiveType.JPrimitiveTypeEnum.CHAR.getType() || rhsType == JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType() || rhsType == JPrimitiveType.JPrimitiveTypeEnum.INT.getType() || rhsType == JPrimitiveType.JPrimitiveTypeEnum.FLOAT.getType() || rhsType == JPrimitiveType.JPrimitiveTypeEnum.LONG.getType() || rhsType == JPrimitiveType.JPrimitiveTypeEnum.DOUBLE.getType() || rhsType instanceof JReferenceType) || rhsType.isSameType(this.jlString) && (lhsType == JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType() || lhsType == JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType() || lhsType == JPrimitiveType.JPrimitiveTypeEnum.CHAR.getType() || lhsType == JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType() || lhsType == JPrimitiveType.JPrimitiveTypeEnum.INT.getType() || lhsType == JPrimitiveType.JPrimitiveTypeEnum.FLOAT.getType() || lhsType == JPrimitiveType.JPrimitiveTypeEnum.LONG.getType() || lhsType == JPrimitiveType.JPrimitiveTypeEnum.DOUBLE.getType() || lhsType instanceof JReferenceType);
    }

    @Override
    @Nonnull
    public JBinaryOperator getOp() {
        return JBinaryOperator.CONCAT;
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }
}

