/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.ast.JAnnotationMethod;
import com.android.jack.ir.ast.JAssertStatement;
import com.android.jack.ir.ast.JDoStatement;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JFieldInitializer;
import com.android.jack.ir.ast.JForStatement;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JNameValuePair;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JValueLiteral;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.JWhileStatement;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.Nonnull;

@Description(value="Java boolean literal expression")
public class JBooleanLiteral
extends JValueLiteral {
    private final boolean value;

    public JBooleanLiteral(SourceInfo sourceInfo, boolean value) {
        super(sourceInfo);
        this.value = value;
    }

    @Override
    public JType getType() {
        return JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType();
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            // empty if block
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Override
    public void checkValidity() {
        if (!(this.parent instanceof JExpression || this.parent instanceof JNameValuePair || this.parent instanceof JAnnotationMethod || this.parent instanceof JAssertStatement || this.parent instanceof JDoStatement || this.parent instanceof JForStatement || this.parent instanceof JIfStatement || this.parent instanceof JReturnStatement || this.parent instanceof JFieldInitializer || this.parent instanceof JWhileStatement)) {
            throw new JNodeInternalError(this, "Invalid parent");
        }
    }

    @Override
    public boolean isTypeValue() {
        return !this.value;
    }
}

