/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JAddOperation;
import com.android.jack.ir.ast.JAndOperation;
import com.android.jack.ir.ast.JAsgAddOperation;
import com.android.jack.ir.ast.JAsgBitAndOperation;
import com.android.jack.ir.ast.JAsgBitOrOperation;
import com.android.jack.ir.ast.JAsgBitXorOperation;
import com.android.jack.ir.ast.JAsgConcatOperation;
import com.android.jack.ir.ast.JAsgDivOperation;
import com.android.jack.ir.ast.JAsgModOperation;
import com.android.jack.ir.ast.JAsgMulOperation;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JAsgShlOperation;
import com.android.jack.ir.ast.JAsgShrOperation;
import com.android.jack.ir.ast.JAsgShruOperation;
import com.android.jack.ir.ast.JAsgSubOperation;
import com.android.jack.ir.ast.JBinaryOperator;
import com.android.jack.ir.ast.JBitAndOperation;
import com.android.jack.ir.ast.JBitOrOperation;
import com.android.jack.ir.ast.JBitXorOperation;
import com.android.jack.ir.ast.JDivOperation;
import com.android.jack.ir.ast.JEqOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JGtOperation;
import com.android.jack.ir.ast.JGteOperation;
import com.android.jack.ir.ast.JLtOperation;
import com.android.jack.ir.ast.JLteOperation;
import com.android.jack.ir.ast.JModOperation;
import com.android.jack.ir.ast.JMulOperation;
import com.android.jack.ir.ast.JNeqOperation;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JOrOperation;
import com.android.jack.ir.ast.JShlOperation;
import com.android.jack.ir.ast.JShrOperation;
import com.android.jack.ir.ast.JShruOperation;
import com.android.jack.ir.ast.JSubOperation;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import javax.annotation.Nonnull;

@Description(value="Binary operator expression")
public abstract class JBinaryOperation
extends JExpression {
    @Nonnull
    private JExpression lhs;
    @Nonnull
    private JExpression rhs;

    JBinaryOperation(@Nonnull SourceInfo info, @Nonnull JExpression lhs, @Nonnull JExpression rhs) {
        super(info);
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Nonnull
    public JExpression getLhs() {
        return this.lhs;
    }

    @Nonnull
    public abstract JBinaryOperator getOp();

    @Nonnull
    public JExpression getRhs() {
        return this.rhs;
    }

    public boolean isAssignment() {
        return this.getOp().isAssignment();
    }

    public boolean isCompoundAssignment() {
        return this.getOp().isCompoundAssignment();
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            visitor.accept(this.lhs);
            visitor.accept(this.rhs);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> instance) throws Exception {
        instance.process(this);
        this.lhs.traverse(instance);
        this.rhs.traverse(instance);
    }

    @Override
    protected void replaceImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException {
        assert (newNode != null);
        if (this.rhs == existingNode) {
            this.rhs = (JExpression)newNode;
        } else if (this.lhs == existingNode) {
            this.lhs = (JExpression)newNode;
        } else {
            super.replaceImpl(existingNode, newNode);
        }
    }

    @Nonnull
    public static JBinaryOperation create(@Nonnull SourceInfo info, @Nonnull JBinaryOperator op, @Nonnull JExpression lhs, @Nonnull JExpression rhs) {
        JBinaryOperation result = null;
        switch (op) {
            case ADD: {
                result = new JAddOperation(info, lhs, rhs);
                break;
            }
            case AND: {
                result = new JAndOperation(info, lhs, rhs);
                break;
            }
            case ASG: {
                result = new JAsgOperation(info, lhs, rhs);
                break;
            }
            case ASG_ADD: {
                result = new JAsgAddOperation(info, lhs, rhs);
                break;
            }
            case ASG_BIT_AND: {
                result = new JAsgBitAndOperation(info, lhs, rhs);
                break;
            }
            case ASG_BIT_OR: {
                result = new JAsgBitOrOperation(info, lhs, rhs);
                break;
            }
            case ASG_BIT_XOR: {
                result = new JAsgBitXorOperation(info, lhs, rhs);
                break;
            }
            case ASG_CONCAT: {
                result = new JAsgConcatOperation(info, lhs, rhs);
                break;
            }
            case ASG_DIV: {
                result = new JAsgDivOperation(info, lhs, rhs);
                break;
            }
            case ASG_MOD: {
                result = new JAsgModOperation(info, lhs, rhs);
                break;
            }
            case ASG_MUL: {
                result = new JAsgMulOperation(info, lhs, rhs);
                break;
            }
            case ASG_SHL: {
                result = new JAsgShlOperation(info, lhs, rhs);
                break;
            }
            case ASG_SHR: {
                result = new JAsgShrOperation(info, lhs, rhs);
                break;
            }
            case ASG_SHRU: {
                result = new JAsgShruOperation(info, lhs, rhs);
                break;
            }
            case ASG_SUB: {
                result = new JAsgSubOperation(info, lhs, rhs);
                break;
            }
            case BIT_AND: {
                result = new JBitAndOperation(info, lhs, rhs);
                break;
            }
            case BIT_OR: {
                result = new JBitOrOperation(info, lhs, rhs);
                break;
            }
            case BIT_XOR: {
                result = new JBitXorOperation(info, lhs, rhs);
                break;
            }
            case CONCAT: {
                throw new AssertionError();
            }
            case DIV: {
                result = new JDivOperation(info, lhs, rhs);
                break;
            }
            case EQ: {
                result = new JEqOperation(info, lhs, rhs);
                break;
            }
            case GT: {
                result = new JGtOperation(info, lhs, rhs);
                break;
            }
            case GTE: {
                result = new JGteOperation(info, lhs, rhs);
                break;
            }
            case LT: {
                result = new JLtOperation(info, lhs, rhs);
                break;
            }
            case LTE: {
                result = new JLteOperation(info, lhs, rhs);
                break;
            }
            case MOD: {
                result = new JModOperation(info, lhs, rhs);
                break;
            }
            case MUL: {
                result = new JMulOperation(info, lhs, rhs);
                break;
            }
            case NEQ: {
                result = new JNeqOperation(info, lhs, rhs);
                break;
            }
            case OR: {
                result = new JOrOperation(info, lhs, rhs);
                break;
            }
            case SHL: {
                result = new JShlOperation(info, lhs, rhs);
                break;
            }
            case SHR: {
                result = new JShrOperation(info, lhs, rhs);
                break;
            }
            case SHRU: {
                result = new JShruOperation(info, lhs, rhs);
                break;
            }
            case SUB: {
                result = new JSubOperation(info, lhs, rhs);
            }
        }
        assert (result != null) : "Unknown operator";
        assert (result.getOp() == op);
        return result;
    }
}

