/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JNullType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.Nonnull;

@Description(value="Java array reference expression")
public class JArrayRef
extends JExpression {
    @Nonnull
    private JExpression indexExpr;
    @Nonnull
    private JExpression instance;

    public JArrayRef(SourceInfo info, @Nonnull JExpression instance, @Nonnull JExpression indexExpr) {
        super(info);
        this.instance = instance;
        this.indexExpr = indexExpr;
    }

    public JArrayType getArrayType() {
        JType type = this.instance.getType();
        if (type instanceof JNullType) {
            return null;
        }
        return (JArrayType)type;
    }

    @Nonnull
    public JExpression getIndexExpr() {
        return this.indexExpr;
    }

    @Nonnull
    public JExpression getInstance() {
        return this.instance;
    }

    @Override
    public JType getType() {
        JArrayType arrayType = this.getArrayType();
        return arrayType == null ? JNullType.INSTANCE : arrayType.getElementType();
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            visitor.accept(this.instance);
            visitor.accept(this.indexExpr);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        this.instance.traverse(schedule);
        this.indexExpr.traverse(schedule);
    }

    @Override
    protected void replaceImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException {
        assert (newNode != null);
        if (this.indexExpr == existingNode) {
            this.indexExpr = (JExpression)newNode;
        } else if (this.instance == existingNode) {
            this.instance = (JExpression)newNode;
        } else {
            super.replaceImpl(existingNode, newNode);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Override
    public void checkValidity() {
        super.checkValidity();
        if (!(this.instance.getType() instanceof JArrayType)) {
            throw new JNodeInternalError(this.instance, "Invalid array expression");
        }
    }
}

