/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.ast.JDefinedAnnotationType;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.load.MethodLoader;
import com.android.sched.item.Description;
import com.android.sched.transform.TransformRequest;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Method of an annotation type")
public class JAnnotationMethod
extends JMethod {
    @CheckForNull
    private JLiteral defaultValue;

    public JAnnotationMethod(@Nonnull SourceInfo info, @Nonnull JMethodId id, @Nonnull JDefinedClassOrInterface enclosingType, int modifier) {
        super(info, id, enclosingType, modifier);
    }

    public JAnnotationMethod(@Nonnull SourceInfo info, @Nonnull JMethodId id, @Nonnull JDefinedClassOrInterface enclosingType, int modifier, @Nonnull MethodLoader loader) {
        super(info, id, enclosingType, modifier, loader);
    }

    public void setDefaultValue(@CheckForNull JLiteral defaultValue) {
        this.defaultValue = defaultValue;
    }

    @CheckForNull
    public JLiteral getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    protected void visitChildren(@Nonnull JVisitor visitor) {
        super.visitChildren(visitor);
        if (this.defaultValue != null) {
            visitor.accept(this.defaultValue);
        }
    }

    @Override
    protected void removeImpl(@Nonnull JNode existingNode) throws UnsupportedOperationException {
        if (existingNode == this.defaultValue) {
            this.defaultValue = null;
        } else {
            super.removeImpl(existingNode);
        }
    }

    @Override
    protected void replaceImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException {
        if (existingNode == this.defaultValue) {
            this.defaultValue = (JLiteral)newNode;
        } else {
            super.replaceImpl(existingNode, newNode);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Override
    public void checkValidity() {
        if (!(this.parent instanceof JDefinedAnnotationType)) {
            throw new JNodeInternalError(this, "Invalid parent");
        }
    }
}

