/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.Jack;
import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JArrayLiteral;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JNameValuePair;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JRetentionPolicy;
import com.android.jack.ir.ast.JVariable;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.ComposedOf;
import com.android.sched.item.Description;
import com.android.sched.item.Tag;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Annotation instance.")
public class JAnnotation
extends JLiteral {
    @Nonnull
    private final List<JNameValuePair> elements = new ArrayList<JNameValuePair>();
    @Nonnull
    private final JAnnotationType type;
    @Nonnull
    private final JRetentionPolicy retentionPolicy;

    public JAnnotation(@Nonnull SourceInfo sourceInfo, @Nonnull JRetentionPolicy retentionPolicy, @Nonnull JAnnotationType type) {
        super(sourceInfo);
        this.type = type;
        this.retentionPolicy = retentionPolicy;
    }

    @Override
    @Nonnull
    public JAnnotationType getType() {
        return this.type;
    }

    @Nonnull
    public JRetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            for (JNameValuePair pair : this.elements) {
                visitor.accept(pair);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        for (JNameValuePair pair : this.elements) {
            pair.traverse(schedule);
        }
    }

    public void put(@Nonnull JNameValuePair pair) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!this.elements.get(i).getName().equals(pair.getName())) continue;
            this.elements.remove(i);
        }
        this.elements.add(pair);
    }

    public void add(@Nonnull JNameValuePair pair) {
        String name = pair.getName();
        if (this.getNameValuePair(name) != null) {
            throw new IllegalArgumentException("Name already added: " + name);
        }
        this.elements.add(pair);
    }

    @Nonnull
    public Collection<JNameValuePair> getNameValuePairs() {
        return Jack.getUnmodifiableCollections().getUnmodifiableCollection(this.elements);
    }

    @CheckForNull
    public JNameValuePair getNameValuePair(@Nonnull JMethodIdWide methodId) {
        for (JNameValuePair pair : this.elements) {
            if (!pair.getMethodId().equals(methodId)) continue;
            return pair;
        }
        return null;
    }

    @CheckForNull
    public JNameValuePair getNameValuePair(@Nonnull String name) {
        for (JNameValuePair pair : this.elements) {
            if (!pair.getName().equals(name)) continue;
            return pair;
        }
        return null;
    }

    @Override
    protected void transform(@Nonnull JNode existingNode, @CheckForNull JNode newNode, @Nonnull JNode.Transformation transformation) throws UnsupportedOperationException {
        if (!JAnnotation.transform(this.elements, existingNode, (JNameValuePair)newNode, transformation)) {
            super.transform(existingNode, newNode, transformation);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Override
    public void checkValidity() {
        if (!(this.parent instanceof JDefinedClassOrInterface || this.parent instanceof JMethod || this.parent instanceof JField || this.parent instanceof JVariable || this.parent instanceof JArrayLiteral || this.parent instanceof JNameValuePair)) {
            throw new JNodeInternalError(this, "Invalid parent");
        }
    }

    @Description(value="Jack IR can contains repeated annotations on methods")
    public static class RepeatedAnnotationOnMethod
    implements Tag {
    }

    @Description(value="Jack IR can contains repeated annotations on fields")
    public static class RepeatedAnnotationOnField
    implements Tag {
    }

    @Description(value="Jack IR can contains repeated annotations on types")
    public static class RepeatedAnnotationOnType
    implements Tag {
    }

    @ComposedOf(value={RepeatedAnnotationOnType.class, RepeatedAnnotationOnField.class, RepeatedAnnotationOnMethod.class})
    @Description(value="Jack IR can contains repeated annotations on types, fields and methods")
    public static class RepeatedAnnotation
    implements Tag {
    }
}

