/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir;

import com.android.jack.ir.HasSourceInfo;
import com.android.jack.ir.sourceinfo.SourceInfo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class JNodeInternalError
extends Error {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private static final ThreadLocal<JNodeInternalError> pendingICE = new ThreadLocal();
    @Nonnull
    private final List<NodeInfo> nodeTrace = new ArrayList<NodeInfo>();

    public static void preload() {
        NodeInfo.preload();
        pendingICE.set(pendingICE.get());
    }

    public JNodeInternalError(@Nonnull HasSourceInfo node, @Nonnull String message) {
        super(message);
        this.addNode(node);
    }

    public JNodeInternalError(@Nonnull Throwable cause) {
        super(cause);
    }

    public JNodeInternalError(@Nonnull String message, @Nonnull Throwable cause) {
        super(message, cause);
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (this.nodeTrace.isEmpty()) {
            return message;
        }
        NodeInfo bottomNode = this.nodeTrace.get(0);
        return message + ": " + bottomNode.getClassName() + " at \"" + String.valueOf(bottomNode.getSourceInfo()) + '\"';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(@Nonnull HasSourceInfo node) {
        JNodeInternalError other = pendingICE.get();
        if (other != null) {
            return;
        }
        String className = null;
        String description = null;
        SourceInfo sourceInfo = null;
        try {
            pendingICE.set(this);
            className = node.getClass().getName();
            sourceInfo = node.getSourceInfo();
            description = node.toString();
        }
        catch (Throwable e) {
            if (description == null) {
                description = "<source info not available>";
            }
        }
        finally {
            pendingICE.set(null);
        }
        assert (className != null);
        this.addNode(className, description, sourceInfo);
    }

    public void addNode(@Nonnull String className, @Nonnull String description, @CheckForNull SourceInfo sourceInfo) {
        this.nodeTrace.add(new NodeInfo(className, description, sourceInfo));
    }

    @Nonnull
    public List<NodeInfo> getNodeTrace() {
        return this.nodeTrace;
    }

    public static final class NodeInfo {
        @Nonnull
        private final String className;
        @Nonnull
        private final String description;
        @CheckForNull
        private final SourceInfo sourceInfo;

        static void preload() {
        }

        NodeInfo(@Nonnull String className, @Nonnull String description, @CheckForNull SourceInfo sourceInfo) {
            this.className = className;
            this.description = description;
            this.sourceInfo = sourceInfo;
        }

        @Nonnull
        public String getClassName() {
            return this.className;
        }

        @Nonnull
        public String getDescription() {
            return this.description;
        }

        @CheckForNull
        public SourceInfo getSourceInfo() {
            return this.sourceInfo;
        }
    }
}

