/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.frontend;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JEnum;
import com.android.jack.ir.ast.JFieldId;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.lookup.JPhantomLookup;
import com.android.jack.transformations.SanityChecks;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Collection;
import javax.annotation.Nonnull;

@Description(value="checks that external instances of JType have been replaced by their resolved counterparts in IR.")
@Name(value="TypeDuplicatesRemoverChecker")
@Support(value={SanityChecks.class})
public class TypeDuplicateRemoverChecker
implements RunnableSchedulable<JSession> {
    @Override
    public void run(@Nonnull JSession session) {
        TypeDuplicateRemoverChecker.checkFieldsOf(Jack.getSession().getPhantomLookup().getClass(), Jack.getSession().getPhantomLookup(), session);
        Visitor visitor = new Visitor(session);
        for (JDefinedClassOrInterface declaredType : session.getTypesToEmit()) {
            visitor.accept(declaredType);
        }
    }

    public static void checkFieldsOf(@Nonnull Class<?> type, @Nonnull Object node, JSession session) {
        JPhantomLookup lookup = session.getPhantomLookup();
        for (Field field : type.getDeclaredFields()) {
            boolean fieldAccess = field.isAccessible();
            try {
                field.setAccessible(true);
                Object fieldObject = field.get(node);
                if (fieldObject instanceof JType) {
                    JType typeField = (JType)fieldObject;
                    if (!(typeField instanceof JClassOrInterface) && !(typeField instanceof JArrayType)) continue;
                    TypeDuplicateRemoverChecker.checkType(node, lookup, field, typeField);
                    if (!(typeField instanceof JArrayType) || ((JArrayType)typeField).getElementType() == node) continue;
                    TypeDuplicateRemoverChecker.checkFieldsOf(typeField.getClass(), typeField, session);
                    continue;
                }
                if (fieldObject instanceof Collection) {
                    Collection collection = (Collection)fieldObject;
                    for (Object object : collection) {
                        if (!(object instanceof JClassOrInterface) && !(object instanceof JArrayType)) continue;
                        TypeDuplicateRemoverChecker.checkType(node, lookup, field, (JType)object);
                    }
                    continue;
                }
                if (fieldObject instanceof JType[]) {
                    JType[] types;
                    for (JType t : types = (JType[])fieldObject) {
                        TypeDuplicateRemoverChecker.checkType(node, lookup, field, t);
                    }
                    continue;
                }
                if (!(fieldObject instanceof JFieldId)) continue;
                TypeDuplicateRemoverChecker.checkFieldsOf(fieldObject.getClass(), fieldObject, session);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)"Error during duplicate types checking.");
            }
            catch (SecurityException e) {
                throw new AssertionError((Object)"Error during duplicate types checking.");
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)"Error during duplicate types checking.");
            }
            finally {
                field.setAccessible(fieldAccess);
            }
        }
        if (type.getSuperclass() != null && type.getSuperclass() != JNode.class) {
            TypeDuplicateRemoverChecker.checkFieldsOf(type.getSuperclass(), node, session);
        }
        for (AnnotatedElement annotatedElement : type.getInterfaces()) {
            TypeDuplicateRemoverChecker.checkFieldsOf(annotatedElement, node, session);
        }
    }

    private static void checkType(@Nonnull Object node, @Nonnull JPhantomLookup lookup, @Nonnull Field f, @Nonnull JType typeToCheck) throws AssertionError {
        String signature = Jack.getLookupFormatter().getName(typeToCheck);
        JType typeFoundInLookup = typeToCheck instanceof JEnum ? lookup.getEnum(signature) : (typeToCheck instanceof JAnnotationType ? lookup.getAnnotationType(signature) : (typeToCheck instanceof JClass ? lookup.getClass(signature) : (typeToCheck instanceof JInterface ? lookup.getInterface(signature) : lookup.getType(signature))));
        if (typeToCheck != typeFoundInLookup) {
            throw TypeDuplicateRemoverChecker.createError(node, f);
        }
    }

    @Nonnull
    private static AssertionError createError(@Nonnull Object checked, @Nonnull Field f) {
        String message = "Duplicate type found in " + checked.toString() + " of class " + checked.getClass().getName() + " in field " + f.getName();
        return new AssertionError((Object)message);
    }

    private static class Visitor
    extends JVisitor {
        @Nonnull
        private final JSession session;

        public Visitor(@Nonnull JSession session) {
            this.session = session;
        }

        @Override
        public void endVisit(@Nonnull JNode x) {
            TypeDuplicateRemoverChecker.checkFieldsOf(x.getClass(), x, this.session);
        }
    }
}

