/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.freemarker.core;

import com.android.jack.freemarker.core.Environment;
import com.android.jack.freemarker.core.MessageUtil;
import com.android.jack.freemarker.core._MiscTemplateException;
import com.android.jack.freemarker.template.Template;
import com.android.jack.freemarker.template.TemplateException;
import com.android.jack.freemarker.template.utility.ClassUtil;
import com.android.jack.freemarker.template.utility.Execute;
import com.android.jack.freemarker.template.utility.ObjectConstructor;

public interface TemplateClassResolver {
    public static final TemplateClassResolver UNRESTRICTED_RESOLVER = new TemplateClassResolver(){

        public Class resolve(String className, Environment env, Template template) throws TemplateException {
            try {
                return ClassUtil.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new _MiscTemplateException((Throwable)e, env);
            }
        }
    };
    public static final TemplateClassResolver SAFER_RESOLVER = new TemplateClassResolver(){

        public Class resolve(String className, Environment env, Template template) throws TemplateException {
            if (className.equals(ObjectConstructor.class.getName()) || className.equals(Execute.class.getName()) || className.equals("com.android.jack.freemarker.template.utility.JythonRuntime")) {
                throw MessageUtil.newInstantiatingClassNotAllowedException(className, env);
            }
            try {
                return ClassUtil.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new _MiscTemplateException((Throwable)e, env);
            }
        }
    };
    public static final TemplateClassResolver ALLOWS_NOTHING_RESOLVER = new TemplateClassResolver(){

        public Class resolve(String className, Environment env, Template template) throws TemplateException {
            throw MessageUtil.newInstantiatingClassNotAllowedException(className, env);
        }
    };

    public Class resolve(String var1, Environment var2, Template var3) throws TemplateException;
}

