/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.freemarker.core;

import com.android.jack.freemarker.core.TemplateDateFormat;
import com.android.jack.freemarker.core.TemplateFormatUtil;
import com.android.jack.freemarker.core.UnparsableValueException;
import com.android.jack.freemarker.template.TemplateDateModel;
import com.android.jack.freemarker.template.TemplateModelException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

class JavaTemplateDateFormat
extends TemplateDateFormat {
    private final DateFormat javaDateFormat;

    public JavaTemplateDateFormat(DateFormat javaDateFormat) {
        this.javaDateFormat = javaDateFormat;
    }

    public String formatToPlainText(TemplateDateModel dateModel) throws TemplateModelException {
        return this.javaDateFormat.format(TemplateFormatUtil.getNonNullDate(dateModel));
    }

    public Date parse(String s, int dateType) throws UnparsableValueException {
        try {
            return this.javaDateFormat.parse(s);
        }
        catch (ParseException e) {
            throw new UnparsableValueException(e.getMessage(), e);
        }
    }

    public String getDescription() {
        return this.javaDateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)this.javaDateFormat).toPattern() : this.javaDateFormat.toString();
    }

    public boolean isLocaleBound() {
        return true;
    }

    public boolean isTimeZoneBound() {
        return true;
    }
}

