/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ecj.loader.jast;

import com.android.jack.ecj.loader.jast.AnnotationUtils;
import com.android.jack.ecj.loader.jast.LoaderUtils;
import com.android.jack.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import com.android.jack.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import com.android.jack.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JAnnotationMethod;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JModifier;
import com.android.jack.ir.ast.JNameValuePair;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.marker.ThrownExceptionMarker;
import com.android.jack.ir.formatter.TypeFormatter;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

class JAstBinaryMethod
implements IBinaryMethod {
    @Nonnull
    private static final char[][] NO_EXCEPTION = new char[0][];
    @Nonnull
    private static final char[][] NO_ARGUMENTS_NAME = new char[0][];
    @Nonnull
    private final JMethod jMethod;

    JAstBinaryMethod(@Nonnull JMethod jMethod) {
        this.jMethod = jMethod;
    }

    @Override
    public int getModifiers() {
        int modifier = LoaderUtils.convertJAstModifiersToEcj(this.jMethod.getModifier(), this.jMethod);
        if (this.getDefaultValue() != null) {
            modifier |= 0x20000;
        }
        return modifier;
    }

    @Override
    public boolean isConstructor() {
        return this.jMethod instanceof JConstructor;
    }

    @Override
    @CheckForNull
    public char[][] getArgumentNames() {
        Object argumentsNames = NO_ARGUMENTS_NAME;
        List<JParameter> params = this.jMethod.getParams();
        if (params.size() != 0) {
            argumentsNames = new char[params.size()][];
        }
        int argIndex = 0;
        for (JParameter jParameter : params) {
            String name = jParameter.getName();
            argumentsNames[argIndex++] = name == null ? null : name.toCharArray();
        }
        return argumentsNames;
    }

    @Override
    @CheckForNull
    public IBinaryAnnotation[] getAnnotations() {
        return AnnotationUtils.convertJAstAnnotationToEcj(this.jMethod, true);
    }

    @Override
    @CheckForNull
    public Object getDefaultValue() {
        Object defaultValue = null;
        if (this.jMethod instanceof JAnnotationMethod) {
            JAnnotationMethod annotationMethod = (JAnnotationMethod)this.jMethod;
            JLiteral jLiteral = annotationMethod.getDefaultValue();
            if (jLiteral != null) {
                defaultValue = AnnotationUtils.getEcjAnnotationValue(jLiteral);
            } else {
                JAnnotation annotation = AnnotationUtils.getAnnotation(this.jMethod.getEnclosingType(), "Ldalvik/annotation/AnnotationDefault;");
                if (annotation != null) {
                    JNameValuePair defaultAnnotationPair = annotation.getNameValuePair("value");
                    assert (defaultAnnotationPair != null);
                    JAnnotation defaultAnnotation = (JAnnotation)defaultAnnotationPair.getValue();
                    JNameValuePair defaultValuePair = defaultAnnotation.getNameValuePair(this.jMethod.getName());
                    if (defaultValuePair != null) {
                        defaultValue = AnnotationUtils.getEcjAnnotationValue(defaultValuePair.getValue());
                    }
                }
            }
        }
        return defaultValue;
    }

    @Override
    @CheckForNull
    public char[][] getExceptionTypeNames() {
        Object exceptionsBinaryNames = NO_EXCEPTION;
        ThrownExceptionMarker marker = this.jMethod.getMarker(ThrownExceptionMarker.class);
        if (marker != null) {
            List<JClass> throwns = marker.getThrownExceptions();
            if (throwns.size() != 0) {
                exceptionsBinaryNames = new char[throwns.size()][];
            }
            int argIndex = 0;
            TypeFormatter formatter = LoaderUtils.getQualifiedNameFormatter();
            for (JClass thrown : throwns) {
                exceptionsBinaryNames[argIndex++] = formatter.getName(thrown).toCharArray();
            }
        }
        return exceptionsBinaryNames;
    }

    @Override
    @CheckForNull
    public char[] getGenericSignature() {
        return LoaderUtils.getGenericSignature(this.jMethod);
    }

    @Override
    @Nonnull
    public char[] getMethodDescriptor() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (JParameter p : this.jMethod.getParams()) {
            sb.append(LoaderUtils.getSignatureFormatter().getName(p.getType()));
        }
        sb.append(')');
        sb.append(LoaderUtils.getSignatureFormatter().getName(this.jMethod.getType()));
        return sb.toString().toCharArray();
    }

    @Override
    @CheckForNull
    public IBinaryAnnotation[] getParameterAnnotations(int index, char[] classFileName) {
        JParameter param = this.jMethod.getParams().get(index);
        return AnnotationUtils.convertJAstAnnotationToEcj(param, false);
    }

    @Override
    @Nonnull
    public char[] getSelector() {
        return this.getMethodName().toCharArray();
    }

    @Override
    public long getTagBits() {
        long tagBits = AnnotationUtils.getTagBits(this.jMethod);
        if (this.jMethod.hasPolymorphicSignature()) {
            tagBits |= 0x10000000000000L;
        }
        return tagBits;
    }

    @Override
    public boolean isClinit() {
        return JModifier.isStaticInitializer(this.jMethod.getModifier());
    }

    @Nonnull
    public String toString() {
        return this.jMethod.toString();
    }

    @Nonnull
    private String getMethodName() {
        return this.jMethod.getName();
    }

    @Override
    public int getAnnotatedParametersCount() {
        int result = 0;
        for (JParameter param : this.jMethod.getParams()) {
            if (param.getAnnotations().size() <= 0) continue;
            ++result;
        }
        return result;
    }

    @Override
    public IBinaryTypeAnnotation[] getTypeAnnotations() {
        return null;
    }
}

