/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.io.instructions;

import com.android.jack.dx.io.IndexType;
import com.android.jack.dx.io.OpcodeInfo;
import com.android.jack.dx.io.instructions.DecodedInstruction;
import com.android.jack.dx.io.instructions.InstructionCodec;

public final class ThreeRegisterDecodedInstruction
extends DecodedInstruction {
    private final int a;
    private final int b;
    private final int c;

    public ThreeRegisterDecodedInstruction(InstructionCodec format, int opcode, int index, IndexType indexType, int target, long literal, int a, int b, int c) {
        this(format, opcode, index, indexType, target, literal, a, b, c, 0, IndexType.NONE);
        assert (!OpcodeInfo.hasDualConstants(opcode));
    }

    public ThreeRegisterDecodedInstruction(InstructionCodec format, int opcode, int firstIndex, IndexType firstIndexType, int target, long literal, int a, int b, int c, int secondIndex, IndexType secondIndexType) {
        super(format, opcode, firstIndex, firstIndexType, target, literal, secondIndex, secondIndexType);
        this.a = a;
        this.b = b;
        this.c = c;
    }

    @Override
    public int getRegisterCount() {
        return 3;
    }

    @Override
    public int getA() {
        return this.a;
    }

    @Override
    public int getB() {
        return this.b;
    }

    @Override
    public int getC() {
        return this.c;
    }

    @Override
    public DecodedInstruction withIndex(int newFirstIndex, int newSecondIndex) {
        return new ThreeRegisterDecodedInstruction(this.getFormat(), this.getOpcode(), newFirstIndex, this.getFirstIndexType(), this.getTarget(), this.getLiteral(), this.a, this.b, this.c, newSecondIndex, this.getSecondIndexType());
    }
}

