/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.dex.file;

import com.android.jack.dx.dex.file.DexFile;
import com.android.jack.dx.dex.file.ItemType;
import com.android.jack.dx.dex.file.OffsettedItem;
import com.android.jack.dx.dex.file.Section;
import com.android.jack.dx.io.DexBuffer;
import com.android.jack.dx.rop.cst.CstIndexMap;
import com.android.jack.dx.util.AnnotatedOutput;
import com.android.jack.dx.util.ByteArrayAnnotatedOutput;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ImportedDebugInfoItem
extends OffsettedItem {
    private static final int ALIGNMENT = 1;
    @Nonnull
    private final DexBuffer dexBuffer;
    @Nonnegative
    private final int debugInfoOffset;
    @CheckForNull
    private byte[] encodedDebugInfo;
    @Nonnull
    private CstIndexMap cstIndexMap;

    public ImportedDebugInfoItem(@Nonnull DexBuffer dexBuffer, @Nonnegative int debugInfoOffset, @Nonnull CstIndexMap cstIndexMap) {
        super(1, -1);
        assert (dexBuffer != null);
        this.dexBuffer = dexBuffer;
        this.debugInfoOffset = debugInfoOffset;
        this.cstIndexMap = cstIndexMap;
    }

    @Override
    public ItemType itemType() {
        return ItemType.TYPE_DEBUG_INFO_ITEM;
    }

    @Override
    public void addContents(DexFile file) {
    }

    @Override
    protected void place0(Section addedTo, int offset) {
        ByteArrayAnnotatedOutput out = new ByteArrayAnnotatedOutput();
        this.encodeAndRemapDebugInfoItem(addedTo.getFile(), out);
        this.encodedDebugInfo = out.toByteArray();
        this.setWriteSize(this.encodedDebugInfo.length);
    }

    @Override
    public String toHuman() {
        throw new RuntimeException("unsupported");
    }

    public void annotateTo(DexFile file, AnnotatedOutput out, String prefix) {
        out.annotate("  debug info not available (imported)");
    }

    @Override
    protected void writeTo0(DexFile file, AnnotatedOutput out) {
        out.write(this.encodedDebugInfo);
    }

    private void encodeAndRemapDebugInfoItem(DexFile file, AnnotatedOutput out) {
        DexBuffer.Section in = this.dexBuffer.open(this.debugInfoOffset);
        int lineStart = in.readUleb128();
        out.writeUleb128(lineStart);
        int parametersSize = in.readUleb128();
        out.writeUleb128(parametersSize);
        for (int p = 0; p < parametersSize; ++p) {
            int parameterName = in.readUleb128p1();
            if (parameterName != -1) {
                out.writeUleb128(this.cstIndexMap.getRemappedCstStringIndex(file, parameterName) + 1);
                continue;
            }
            out.writeUleb128(0);
        }
        while (true) {
            byte opcode = in.readByte();
            out.writeByte(opcode);
            switch (opcode) {
                case 0: {
                    return;
                }
                case 1: {
                    int addrDiff = in.readUleb128();
                    out.writeUleb128(addrDiff);
                    break;
                }
                case 2: {
                    int lineDiff = in.readSleb128();
                    out.writeSleb128(lineDiff);
                    break;
                }
                case 3: 
                case 4: {
                    int registerNum = in.readUleb128();
                    out.writeUleb128(registerNum);
                    int nameIndex = in.readUleb128p1();
                    out.writeUleb128(this.cstIndexMap.getRemappedCstStringIndex(file, nameIndex) + 1);
                    int typeIndex = in.readUleb128p1();
                    out.writeUleb128(this.cstIndexMap.getRemappedCstTypeIndex(file, typeIndex) + 1);
                    if (opcode != 4) break;
                    int sigIndex = in.readUleb128p1();
                    out.writeUleb128(this.cstIndexMap.getRemappedCstStringIndex(file, sigIndex) + 1);
                    break;
                }
                case 5: 
                case 6: {
                    int registerNum = in.readUleb128();
                    out.writeUleb128(registerNum);
                    break;
                }
                case 9: {
                    int nameIndex = in.readUleb128p1();
                    out.writeUleb128(this.cstIndexMap.getRemappedCstStringIndex(file, nameIndex) + 1);
                    break;
                }
            }
        }
    }
}

