/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.dex.file;

import com.android.jack.dx.dex.DexOptions;
import com.android.jack.dx.dex.file.ClassDefItem;
import com.android.jack.dx.dex.file.ClassDefsSection;
import com.android.jack.dx.dex.file.FieldIdsSection;
import com.android.jack.dx.dex.file.HeaderSection;
import com.android.jack.dx.dex.file.IndexedItem;
import com.android.jack.dx.dex.file.ItemType;
import com.android.jack.dx.dex.file.MapItem;
import com.android.jack.dx.dex.file.MethodIdsSection;
import com.android.jack.dx.dex.file.MixedItemSection;
import com.android.jack.dx.dex.file.ProtoIdsSection;
import com.android.jack.dx.dex.file.Section;
import com.android.jack.dx.dex.file.Statistics;
import com.android.jack.dx.dex.file.StringIdsSection;
import com.android.jack.dx.dex.file.TypeIdsSection;
import com.android.jack.dx.rop.cst.Constant;
import com.android.jack.dx.rop.cst.CstBaseMethodRef;
import com.android.jack.dx.rop.cst.CstEnumRef;
import com.android.jack.dx.rop.cst.CstFieldRef;
import com.android.jack.dx.rop.cst.CstMethodRef;
import com.android.jack.dx.rop.cst.CstPrototypeRef;
import com.android.jack.dx.rop.cst.CstString;
import com.android.jack.dx.rop.cst.CstType;
import com.android.jack.dx.util.ByteArrayAnnotatedOutput;
import com.android.jack.dx.util.ExceptionWithContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.zip.Adler32;
import javax.annotation.Nonnull;

public final class DexFile {
    private DexOptions dexOptions;
    private final MixedItemSection wordData;
    private final MixedItemSection typeLists;
    private final MixedItemSection map;
    private final MixedItemSection stringData;
    private final StringIdsSection stringIds;
    private final TypeIdsSection typeIds;
    private final ProtoIdsSection protoIds;
    private final FieldIdsSection fieldIds;
    private final MethodIdsSection methodIds;
    private final ClassDefsSection classDefs;
    private final MixedItemSection classData;
    private final MixedItemSection byteData;
    private final HeaderSection header;
    private final Section[] sections;
    private int fileSize;
    private int dumpWidth;

    public DexFile(DexOptions dexOptions) {
        this.dexOptions = dexOptions;
        this.header = new HeaderSection(this);
        this.typeLists = new MixedItemSection(null, this, 4, MixedItemSection.SortType.NONE);
        this.wordData = new MixedItemSection("word_data", this, 4, MixedItemSection.SortType.TYPE);
        this.stringData = new MixedItemSection("string_data", this, 1, MixedItemSection.SortType.INSTANCE);
        this.classData = new MixedItemSection(null, this, 1, MixedItemSection.SortType.NONE);
        this.byteData = new MixedItemSection("byte_data", this, 1, MixedItemSection.SortType.TYPE);
        this.stringIds = new StringIdsSection(this);
        this.typeIds = new TypeIdsSection(this);
        this.protoIds = new ProtoIdsSection(this);
        this.fieldIds = new FieldIdsSection(this);
        this.methodIds = new MethodIdsSection(this);
        this.classDefs = new ClassDefsSection(this);
        this.map = new MixedItemSection("map", this, 4, MixedItemSection.SortType.NONE);
        this.sections = new Section[]{this.header, this.stringIds, this.typeIds, this.protoIds, this.fieldIds, this.methodIds, this.classDefs, this.wordData, this.typeLists, this.stringData, this.byteData, this.classData, this.map};
        this.fileSize = -1;
        this.dumpWidth = 79;
    }

    public boolean isEmpty() {
        return this.classDefs.items().isEmpty();
    }

    public DexOptions getDexOptions() {
        return this.dexOptions;
    }

    public void add(ClassDefItem clazz) {
        this.classDefs.add(clazz);
    }

    public void writeTo(OutputStream out, Writer humanOut, boolean verbose) throws IOException {
        boolean annotate = humanOut != null;
        ByteArrayAnnotatedOutput result = this.toDex0(annotate, verbose);
        if (out != null) {
            out.write(result.getArray());
        }
        if (annotate) {
            result.writeAnnotationsTo(humanOut);
        }
    }

    public byte[] toDex(Writer humanOut, boolean verbose) throws IOException {
        boolean annotate = humanOut != null;
        ByteArrayAnnotatedOutput result = this.toDex0(annotate, verbose);
        if (annotate) {
            result.writeAnnotationsTo(humanOut);
        }
        return result.getArray();
    }

    public void setDumpWidth(int dumpWidth) {
        if (dumpWidth < 40) {
            throw new IllegalArgumentException("dumpWidth < 40");
        }
        this.dumpWidth = dumpWidth;
    }

    int getFileSize() {
        if (this.fileSize < 0) {
            throw new RuntimeException("file size not yet known");
        }
        return this.fileSize;
    }

    MixedItemSection getStringData() {
        return this.stringData;
    }

    MixedItemSection getWordData() {
        return this.wordData;
    }

    MixedItemSection getTypeLists() {
        return this.typeLists;
    }

    MixedItemSection getMap() {
        return this.map;
    }

    public StringIdsSection getStringIds() {
        return this.stringIds;
    }

    ClassDefsSection getClassDefs() {
        return this.classDefs;
    }

    MixedItemSection getClassData() {
        return this.classData;
    }

    public TypeIdsSection getTypeIds() {
        return this.typeIds;
    }

    ProtoIdsSection getProtoIds() {
        return this.protoIds;
    }

    public FieldIdsSection getFieldIds() {
        return this.fieldIds;
    }

    public MethodIdsSection getMethodIds() {
        return this.methodIds;
    }

    MixedItemSection getByteData() {
        return this.byteData;
    }

    Section getFirstDataSection() {
        return this.wordData;
    }

    Section getLastDataSection() {
        return this.map;
    }

    void internIfAppropriate(Constant cst) {
        if (cst instanceof CstString) {
            this.stringIds.intern((CstString)cst);
        } else if (cst instanceof CstType) {
            this.typeIds.intern((CstType)cst);
        } else if (cst instanceof CstBaseMethodRef) {
            this.methodIds.intern((CstBaseMethodRef)cst);
        } else if (cst instanceof CstFieldRef) {
            this.fieldIds.intern((CstFieldRef)cst);
        } else if (cst instanceof CstEnumRef) {
            this.fieldIds.intern(((CstEnumRef)cst).getFieldRef());
        } else if (cst instanceof CstPrototypeRef) {
            this.protoIds.intern(((CstPrototypeRef)cst).getPrototype());
        } else if (cst == null) {
            throw new NullPointerException("cst == null");
        }
    }

    public IndexedItem findItemOrNull(Constant cst) {
        if (cst instanceof CstString) {
            return this.stringIds.get(cst);
        }
        if (cst instanceof CstType) {
            return this.typeIds.get(cst);
        }
        if (cst instanceof CstBaseMethodRef) {
            return this.methodIds.get(cst);
        }
        if (cst instanceof CstFieldRef) {
            return this.fieldIds.get(cst);
        }
        if (cst instanceof CstPrototypeRef) {
            return this.protoIds.get(cst);
        }
        return null;
    }

    public void prepare() {
        this.prepare(Collections.<CstString>emptyList(), Collections.<CstFieldRef>emptyList(), Collections.<CstMethodRef>emptyList(), Collections.<CstType>emptyList(), Collections.<CstPrototypeRef>emptyList());
    }

    public void prepare(@Nonnull Collection<CstString> cstStrings, @Nonnull Collection<CstFieldRef> cstFieldRefs, @Nonnull Collection<CstMethodRef> cstMethodRefs, @Nonnull Collection<CstType> cstTypes, @Nonnull Collection<CstPrototypeRef> cstPrototypeRefs) {
        int n;
        for (CstString cstString : cstStrings) {
            this.stringIds.intern(cstString);
        }
        for (CstFieldRef cstFieldRef : cstFieldRefs) {
            this.fieldIds.intern(cstFieldRef);
        }
        for (CstMethodRef cstMethodRef : cstMethodRefs) {
            this.methodIds.intern(cstMethodRef);
        }
        for (CstType cstType : cstTypes) {
            this.typeIds.intern(cstType);
        }
        for (CstPrototypeRef cstPrototypeRef : cstPrototypeRefs) {
            this.protoIds.intern(cstPrototypeRef.getPrototype());
        }
        this.classDefs.prepare();
        this.classData.prepare();
        this.wordData.prepare();
        this.byteData.prepare();
        this.methodIds.prepare();
        this.fieldIds.prepare();
        this.protoIds.prepare();
        this.typeLists.prepare();
        this.typeIds.prepare();
        this.stringIds.prepare();
        this.stringData.prepare();
        this.header.prepare();
        int count = this.sections.length;
        boolean bl = false;
        for (int i = 0; i < count; ++i) {
            Section one = this.sections[i];
            int placedAt = one.setFileOffset(n);
            if (placedAt < n) {
                throw new RuntimeException("bogus placement for section " + i);
            }
            try {
                if (one == this.map) {
                    MapItem.addMap(this.sections, this.map);
                    this.map.prepare();
                }
                if (one instanceof MixedItemSection) {
                    ((MixedItemSection)one).placeItems();
                }
                n = placedAt + one.writeSize();
                continue;
            }
            catch (RuntimeException ex) {
                throw ExceptionWithContext.withContext(ex, "...while writing section " + i);
            }
        }
        this.fileSize = n;
    }

    private ByteArrayAnnotatedOutput toDex0(boolean annotate, boolean verbose) {
        this.classDefs.throwIfNotPrepared();
        this.classData.throwIfNotPrepared();
        this.wordData.throwIfNotPrepared();
        this.byteData.throwIfNotPrepared();
        this.methodIds.throwIfNotPrepared();
        this.fieldIds.throwIfNotPrepared();
        this.protoIds.throwIfNotPrepared();
        this.typeLists.throwIfNotPrepared();
        this.typeIds.throwIfNotPrepared();
        this.stringIds.throwIfNotPrepared();
        this.stringData.throwIfNotPrepared();
        this.header.throwIfNotPrepared();
        int count = this.sections.length;
        byte[] barr = new byte[this.fileSize];
        ByteArrayAnnotatedOutput out = new ByteArrayAnnotatedOutput(barr);
        if (annotate) {
            out.enableAnnotations(this.dumpWidth, verbose);
        }
        for (int i = 0; i < count; ++i) {
            try {
                Section one = this.sections[i];
                int zeroCount = one.getFileOffset() - out.getCursor();
                if (zeroCount < 0) {
                    throw new ExceptionWithContext("excess write of " + -zeroCount);
                }
                out.writeZeroes(one.getFileOffset() - out.getCursor());
                one.writeTo(out);
                continue;
            }
            catch (RuntimeException ex) {
                ExceptionWithContext ec = ex instanceof ExceptionWithContext ? (ExceptionWithContext)ex : new ExceptionWithContext(ex);
                ec.addContext("...while writing section " + i);
                throw ec;
            }
        }
        if (out.getCursor() != this.fileSize) {
            throw new RuntimeException("foreshortened write");
        }
        DexFile.calcSignature(barr);
        DexFile.calcChecksum(barr);
        if (annotate) {
            this.wordData.writeIndexAnnotation(out, ItemType.TYPE_CODE_ITEM, "\nmethod code index:\n\n");
            this.getStatistics().writeAnnotation(out);
            out.finishAnnotating();
        }
        return out;
    }

    public Statistics getStatistics() {
        Statistics stats = new Statistics();
        for (Section s : this.sections) {
            stats.addAll(s);
        }
        return stats;
    }

    private static void calcSignature(byte[] bytes) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        md.update(bytes, 32, bytes.length - 32);
        try {
            int amt = md.digest(bytes, 12, 20);
            if (amt != 20) {
                throw new RuntimeException("unexpected digest write: " + amt + " bytes");
            }
        }
        catch (DigestException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void calcChecksum(byte[] bytes) {
        Adler32 a32 = new Adler32();
        a32.update(bytes, 12, bytes.length - 12);
        int sum = (int)a32.getValue();
        bytes[8] = (byte)sum;
        bytes[9] = (byte)(sum >> 8);
        bytes[10] = (byte)(sum >> 16);
        bytes[11] = (byte)(sum >> 24);
    }
}

