/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.cfg;

import com.android.jack.Jack;
import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.CatchBasicBlock;
import com.android.jack.cfg.ExitBlock;
import com.android.jack.cfg.NormalBasicBlock;
import com.android.jack.ir.ast.JStatement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class PeiBasicBlock
extends NormalBasicBlock {
    @Nonnegative
    protected static final int UNCAUGHT_PEI_EXIT_BLOCK_INDEX = 1;
    @Nonnegative
    private static final int EXCEPTION_BLOCKS_START_INDEX = 2;
    @Nonnegative
    private static final int SIZE_WHEN_NO_CATCH = 2;

    public PeiBasicBlock(@Nonnegative int id, @Nonnull List<JStatement> statements) {
        super(id, statements, 2);
    }

    public void addExceptionBlock(@Nonnull CatchBasicBlock exceptionBb) {
        this.addSuccessor(2, exceptionBb);
    }

    public void setExitBlockWhenUncaught(@Nonnull ExitBlock exitBlock) {
        this.setSuccessor(1, exitBlock);
    }

    public boolean isExceptionOrUncaughtBlock(@Nonnull BasicBlock basicBlock) {
        return this.getInternalSuccessors().get(0) != basicBlock;
    }

    @Nonnull
    public List<CatchBasicBlock> getExceptionBlocks() {
        return this.getInternalSuccessors().subList(2, this.getInternalSuccessors().size());
    }

    @Override
    @Nonnull
    public List<BasicBlock> getSuccessors() {
        ArrayList<BasicBlock> filteredSuccessors = new ArrayList<BasicBlock>(Math.max(this.successors.size() - 1, 2));
        for (BasicBlock succ : this.successors) {
            if (succ == null) continue;
            filteredSuccessors.add(succ);
        }
        return Jack.getUnmodifiableCollections().getUnmodifiableList(filteredSuccessors);
    }
}

