/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.jayce;

import com.android.jack.Jack;
import com.android.jack.JackAbortException;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.formatter.BinaryQualifiedNameFormatter;
import com.android.jack.jayce.JayceWriterFactory;
import com.android.jack.library.FileType;
import com.android.jack.library.InputLibrary;
import com.android.jack.library.LibraryIOException;
import com.android.jack.library.LibraryLocation;
import com.android.jack.library.LibraryWritingException;
import com.android.jack.library.OutputJackLibrary;
import com.android.jack.library.TypeInInputLibraryLocation;
import com.android.jack.reporting.Reporter;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.HasLocation;
import com.android.sched.util.location.Location;
import com.android.sched.vfs.OutputVFile;
import com.android.sched.vfs.VPath;
import java.io.BufferedOutputStream;
import java.io.IOException;
import javax.annotation.Nonnull;

public abstract class JayceInLibraryWriter
implements RunnableSchedulable<JDefinedClassOrInterface> {
    @Nonnull
    private final OutputJackLibrary outputJackLibrary;

    public JayceInLibraryWriter() {
        OutputJackLibrary ojl = Jack.getSession().getJackOutputLibrary();
        assert (ojl != null);
        this.outputJackLibrary = ojl;
    }

    @Synchronized
    public boolean needsSynchronization() {
        return this.outputJackLibrary.needsSequentialWriting();
    }

    @Override
    public void run(@Nonnull JDefinedClassOrInterface type) {
        Location loc = type.getLocation();
        if (loc instanceof TypeInInputLibraryLocation) {
            InputLibrary inputLibrary = ((TypeInInputLibraryLocation)loc).getInputLibrary();
            LibraryLocation inputLibraryLocation = inputLibrary.getLocation();
            if (inputLibrary.containsFileType(FileType.JAYCE) && this.outputJackLibrary.containsLibraryLocation(inputLibraryLocation)) {
                return;
            }
        }
        try {
            OutputVFile vFile = this.outputJackLibrary.createFile(FileType.JAYCE, new VPath(BinaryQualifiedNameFormatter.getFormatter().getName(type), '/'));
            try (BufferedOutputStream out = new BufferedOutputStream(vFile.getOutputStream());){
                try {
                    JayceWriterFactory.get(this.outputJackLibrary, out).write(type);
                }
                catch (IOException e) {
                    throw new CannotReadException(vFile, (Throwable)e);
                }
            }
            catch (IOException e) {
                throw new CannotCloseException((HasLocation)vFile, (Exception)e);
            }
        }
        catch (CannotCloseException | CannotCreateFileException | CannotReadException | WrongPermissionException e) {
            LibraryWritingException reportable = new LibraryWritingException(new LibraryIOException(this.outputJackLibrary.getLocation(), e));
            Jack.getSession().getReporter().report(Reporter.Severity.FATAL, reportable);
            throw new JackAbortException(reportable);
        }
    }

    @Nonnull
    protected VPath getFilePath(@Nonnull JDefinedClassOrInterface type) {
        return new VPath(BinaryQualifiedNameFormatter.getFormatter().getName(type) + ".jayce", '/');
    }
}

