/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex;

import com.android.jack.JackEventType;
import com.android.jack.backend.dex.DexWritingException;
import com.android.jack.backend.dex.DexWritingTool;
import com.android.jack.backend.dex.MainDexOverflowException;
import com.android.jack.backend.dex.MultiDexWritingTool;
import com.android.jack.tools.merger.JackMerger;
import com.android.jack.tools.merger.MergingOverflowException;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.log.Event;
import com.android.sched.vfs.OutputVFS;
import com.android.sched.vfs.OutputVFile;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nonnull;

@ImplementationName(iface=DexWritingTool.class, name="multidex", description="allow emitting several dex files")
public class StandardMultiDexWritingTool
extends DexWritingTool
implements MultiDexWritingTool {
    @Override
    public void write(@Nonnull OutputVFS outputVDir) throws DexWritingException {
        int dexCount = 1;
        HashSet<DexWritingTool.MatchableInputVFile> mainDexList = new HashSet<DexWritingTool.MatchableInputVFile>();
        ArrayList<DexWritingTool.MatchableInputVFile> anyDexList = new ArrayList<DexWritingTool.MatchableInputVFile>();
        this.fillDexLists(mainDexList, anyDexList);
        try (Event event = this.tracer.open(JackEventType.DEX_MERGER);){
            JackMerger merger = new JackMerger(this.createDexFile());
            OutputVFile outputDex = this.getOutputDex(outputVDir, dexCount++);
            for (DexWritingTool.MatchableInputVFile currentDex : mainDexList) {
                try {
                    this.mergeDex(merger, currentDex.getInputVFile());
                }
                catch (MergingOverflowException e) {
                    throw new DexWritingException(new MainDexOverflowException(e));
                }
            }
            for (DexWritingTool.MatchableInputVFile currentDex : anyDexList) {
                try {
                    this.mergeDex(merger, currentDex.getInputVFile());
                }
                catch (MergingOverflowException e) {
                    this.finishMerge(merger, outputDex);
                    outputDex = this.getOutputDex(outputVDir, dexCount++);
                    merger = new JackMerger(this.createDexFile());
                    try {
                        this.mergeDex(merger, currentDex.getInputVFile());
                    }
                    catch (MergingOverflowException e1) {
                        throw new AssertionError((Object)e1);
                    }
                }
            }
            this.finishMerge(merger, outputDex);
        }
    }
}

