/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex;

import com.android.jack.Options;
import com.android.jack.backend.dex.ForceInMainDexMarker;
import com.android.jack.backend.dex.MainDexMarker;
import com.android.jack.backend.dex.MultiDex;
import com.android.jack.backend.dex.MultiDexLegacy;
import com.android.jack.backend.dex.MultiDexLegacyTracerBrush;
import com.android.jack.backend.dex.TypeReferenceCollector;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JType;
import com.android.jack.shrob.shrink.KeepMarker;
import com.android.jack.shrob.shrink.Shrinking;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Access;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Optional;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.ToSupport;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Marks all classes that must be be kept in the main dex.")
@Transform(add={MainDexMarker.class})
@Constraint(need={ForceInMainDexMarker.class})
@Support(value={MultiDex.class})
@Optional(value={@ToSupport(feature={Shrinking.class}, add={@Constraint(need={KeepMarker.class})}), @ToSupport(feature={MultiDexLegacy.class}, add={@Constraint(need={MultiDexLegacyTracerBrush.TracerMarker.class})})})
@Access(value=JSession.class)
public class MainDexCollector
extends TypeReferenceCollector
implements RunnableSchedulable<JDefinedClassOrInterface> {
    private final boolean isShrinkEnabled = ThreadConfig.get(Options.SHROB_ENABLED) != false && ThreadConfig.get(Options.FLAGS).shrink();

    @Override
    protected void collect(@Nonnull JType type) {
        if (type instanceof JDefinedClassOrInterface) {
            JDefinedClassOrInterface jDefinedClassOrInterface = (JDefinedClassOrInterface)type;
            jDefinedClassOrInterface.addMarkerIfAbsent(MainDexMarker.INSTANCE);
        }
    }

    @Override
    public void run(@Nonnull JDefinedClassOrInterface type) {
        if (type.containsMarker(MultiDexLegacyTracerBrush.TracerMarker.class) && (!this.isShrinkEnabled || type.containsMarker(KeepMarker.class))) {
            this.collect(type);
            this.accept(type);
        } else if (type.containsMarker(ForceInMainDexMarker.class)) {
            this.collect(type);
        }
    }
}

