/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex;

import com.android.jack.backend.dex.ConstantBuilder;
import com.android.jack.backend.dex.rop.RopHelper;
import com.android.jack.dx.dex.file.ClassDefItem;
import com.android.jack.dx.dex.file.EncodedField;
import com.android.jack.dx.rop.cst.CstFieldRef;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.scheduling.marker.ClassDefItemMarker;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.Protect;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import javax.annotation.Nonnull;

@Description(value="Builds EncodedField from JField")
@Name(value="EncodedFieldBuilder")
@Synchronized
@Constraint(need={ClassDefItemMarker.class})
@Transform(add={ClassDefItemMarker.Field.class}, modify={ClassDefItemMarker.class})
@Protect(add={JField.class}, modify={JField.class}, remove={JField.class})
@Filter(value={TypeWithoutPrebuiltFilter.class})
public class EncodedFieldBuilder
implements RunnableSchedulable<JField> {
    @Override
    public synchronized void run(@Nonnull JField field) {
        JDefinedClassOrInterface declaringClass = field.getEnclosingType();
        ClassDefItemMarker classDefItemMarker = declaringClass.getMarker(ClassDefItemMarker.class);
        assert (classDefItemMarker != null);
        ClassDefItem classDefItem = classDefItemMarker.getClassDefItem();
        assert (classDefItem != null);
        EncodedField encodedField = this.createEncodedField(field);
        if (field.isStatic()) {
            JLiteral initialValue = field.getInitialValue();
            classDefItem.addStaticField(encodedField, initialValue != null ? new ConstantBuilder().parseLiteral(initialValue) : null);
        } else {
            assert (field.getInitialValue() == null);
            classDefItem.addInstanceField(encodedField);
        }
    }

    @Nonnull
    private EncodedField createEncodedField(@Nonnull JField field) {
        CstFieldRef fieldRef = RopHelper.createFieldRef(field, (JClassOrInterface)field.getEnclosingType());
        return new EncodedField(fieldRef, EncodedFieldBuilder.getDxAccessFlags(field));
    }

    private static int getDxAccessFlags(@Nonnull JField field) {
        return field.getModifier() & 0x50DF;
    }
}

