/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.backend.dex.rop.RopHelper;
import com.android.jack.dx.dex.file.ClassDefItem;
import com.android.jack.dx.rop.cst.CstString;
import com.android.jack.dx.rop.cst.CstType;
import com.android.jack.dx.rop.type.TypeList;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.scheduling.marker.ClassDefItemMarker;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.Access;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.Protect;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.file.FileUtils;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Builds ClassDefItem from JDeclaredType.")
@Name(value="ClassDefItemBuilder")
@Synchronized
@Transform(add={ClassDefItemMarker.class})
@Protect(add={JDefinedClassOrInterface.class}, modify={JDefinedClassOrInterface.class}, remove={JDefinedClassOrInterface.class})
@Filter(value={TypeWithoutPrebuiltFilter.class})
@Access(value=JSession.class)
public class ClassDefItemBuilder
implements RunnableSchedulable<JDefinedClassOrInterface> {
    private final boolean emitSourceFileInfo = ThreadConfig.get(Options.EMIT_SOURCE_FILE_DEBUG_INFO);

    @Override
    public synchronized void run(@Nonnull JDefinedClassOrInterface declaredType) {
        ClassDefItem classDefItem = this.createClassDefItem(declaredType);
        ClassDefItemMarker classDefItemMarker = new ClassDefItemMarker(classDefItem);
        declaredType.addMarker(classDefItemMarker);
    }

    @Nonnull
    private ClassDefItem createClassDefItem(@Nonnull JDefinedClassOrInterface type) throws JTypeLookupException {
        CstType thisClass = RopHelper.getCstType(type);
        CstType superclassType = ClassDefItemBuilder.createSuperClass(type);
        int accessFlags = this.getDxAccessFlagsForType(type);
        TypeList interfaces = ClassDefItemBuilder.createInterfacesList(type);
        CstString sourceFile = null;
        if (this.emitSourceFileInfo) {
            sourceFile = ClassDefItemBuilder.createSourceFile(type);
        }
        ClassDefItem classDefItem = new ClassDefItem(thisClass, accessFlags, superclassType, interfaces, sourceFile);
        return classDefItem;
    }

    @CheckForNull
    private static CstType createSuperClass(@Nonnull JDefinedClassOrInterface type) throws JTypeLookupException {
        JClass superClass = type.getSuperClass();
        if (superClass == null) {
            if (type instanceof JDefinedInterface) {
                return RopHelper.getCstType(Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_OBJECT));
            }
            assert (type.isSameType(Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_OBJECT)));
            return null;
        }
        CstType superclassType = RopHelper.getCstType(superClass);
        return superclassType;
    }

    @Nonnull
    private static TypeList createInterfacesList(@Nonnull JDefinedClassOrInterface type) {
        List<JInterface> interfacesList = type.getImplements();
        return RopHelper.createTypeList(interfacesList);
    }

    @CheckForNull
    private static CstString createSourceFile(@Nonnull JDefinedClassOrInterface type) {
        CstString sourceFile = null;
        SourceInfo sourceInfo = type.getSourceInfo();
        if (sourceInfo != SourceInfo.UNKNOWN) {
            String fileSeparator;
            String sourceFileName = sourceInfo.getFileName();
            int separatorPos = sourceFileName.lastIndexOf(fileSeparator = FileUtils.getFileSeparator());
            if (separatorPos > 0) {
                sourceFileName = sourceFileName.substring(separatorPos + 1);
            }
            sourceFile = new CstString(sourceFileName);
        }
        return sourceFile;
    }

    private int getDxAccessFlagsForType(@Nonnull JDefinedClassOrInterface type) {
        boolean isInner;
        int accessFlags = type.getModifier();
        boolean bl = isInner = type.getEnclosingType() != null;
        if (isInner && type.isProtected()) {
            accessFlags |= 1;
        }
        if (type.isAnonymous() && !type.isStatic()) {
            accessFlags &= 0xFFFFFFEF;
        }
        return accessFlags &= 0x7631;
    }
}

