/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.analysis.dependency.type;

import com.android.jack.analysis.dependency.Dependency;
import com.android.jack.analysis.dependency.file.FileDependencies;
import com.android.jack.google.common.io.LineReader;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.formatter.BinaryQualifiedNameFormatter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.item.Tag;
import com.android.sched.vfs.VPath;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class TypeDependencies
extends Dependency {
    @Nonnull
    public static final VPath vpath = new VPath("types", '/');
    @Nonnull
    private Map<String, Set<String>> codeDependencies = new HashMap<String, Set<String>>();
    @Nonnull
    private Map<String, Set<String>> hierarchyDependencies = new HashMap<String, Set<String>>();
    @Nonnull
    private Map<String, Set<String>> constantDependencies = new HashMap<String, Set<String>>();

    void createEmptyDependencyIfNeeded(@Nonnull JType type) {
        String typeFqn = BinaryQualifiedNameFormatter.getFormatter().getName(type);
        if (this.hierarchyDependencies.get(typeFqn) == null) {
            this.hierarchyDependencies.put(typeFqn, Collections.emptySet());
        }
        if (this.codeDependencies.get(typeFqn) == null) {
            this.codeDependencies.put(typeFqn, Collections.emptySet());
        }
        if (this.constantDependencies.get(typeFqn) == null) {
            this.constantDependencies.put(typeFqn, Collections.emptySet());
        }
    }

    public void addHierarchyDependency(@Nonnull JType depender, @Nonnull JType dependee) {
        this.addDependency(this.hierarchyDependencies, depender, dependee);
    }

    public void addConstantDependency(@Nonnull JType depender, @Nonnull JType dependee) {
        this.addDependency(this.constantDependencies, depender, dependee);
    }

    public void addCodeDependency(@Nonnull JType depender, @Nonnull JType dependee) {
        this.addDependency(this.codeDependencies, depender, dependee);
    }

    public void write(@Nonnull PrintStream ps) {
        this.writeMapOne2Many(ps, this.hierarchyDependencies);
        ps.print("#");
        ps.println();
        this.writeMapOne2Many(ps, this.constantDependencies);
        ps.print("#");
        ps.println();
        this.writeMapOne2Many(ps, this.codeDependencies);
        ps.print("#");
        ps.println();
    }

    @Nonnull
    public Map<String, Set<String>> getRecompileDependencies() {
        HashMap<String, Set<String>> recompileDependencies = new HashMap<String, Set<String>>();
        HashSet<String> allKeys = new HashSet<String>(this.codeDependencies.keySet());
        allKeys.addAll(this.constantDependencies.keySet());
        allKeys.addAll(this.hierarchyDependencies.keySet());
        for (String typeToRecompile : allKeys) {
            HashSet typesToRecompile = (HashSet)recompileDependencies.get(typeToRecompile);
            if (typesToRecompile == null) {
                typesToRecompile = new HashSet();
                recompileDependencies.put(typeToRecompile, typesToRecompile);
            }
            this.computeCodeRecompileDependencies(recompileDependencies, this.codeDependencies.get(typeToRecompile), typeToRecompile);
            this.computeConstantRecompileDependencies(recompileDependencies, this.constantDependencies.get(typeToRecompile), typeToRecompile, new HashSet<String>());
            this.computeHierarchyRecompileDependencies(recompileDependencies, this.hierarchyDependencies.get(typeToRecompile), typeToRecompile);
        }
        return recompileDependencies;
    }

    private void addDependency(@Nonnull Map<String, Set<String>> typeDependencies, @Nonnull JType depender, @Nonnull JType dependee) {
        String dependsOnTypeFqn;
        String typeFqn = BinaryQualifiedNameFormatter.getFormatter().getName(depender);
        if (!typeFqn.equals(dependsOnTypeFqn = BinaryQualifiedNameFormatter.getFormatter().getName(dependee))) {
            Set<String> dependencies = typeDependencies.get(typeFqn);
            if (dependencies == null) {
                dependencies = new HashSet<String>();
                typeDependencies.put(typeFqn, dependencies);
            }
            dependencies.add(dependsOnTypeFqn);
        }
    }

    private void computeCodeRecompileDependencies(@Nonnull Map<String, Set<String>> recompileDependencies, @CheckForNull Set<String> codeDependencies, @Nonnull String typeToRecompile) {
        if (codeDependencies != null) {
            for (String codeDependency : codeDependencies) {
                Set<String> typesToRecompile = recompileDependencies.get(codeDependency);
                if (typesToRecompile == null) {
                    typesToRecompile = new HashSet<String>();
                    recompileDependencies.put(codeDependency, typesToRecompile);
                }
                typesToRecompile.add(typeToRecompile);
                Set<String> hierarchyDeps = this.hierarchyDependencies.get(codeDependency);
                if (hierarchyDeps == null) continue;
                this.computeCodeRecompileDependencies(recompileDependencies, hierarchyDeps, typeToRecompile);
            }
        }
    }

    private void computeConstantRecompileDependencies(@Nonnull Map<String, Set<String>> recompileDependencies, @CheckForNull Set<String> constantDependencies, @Nonnull String typeToRecompile, @Nonnull Set<String> alreadyVisited) {
        if (constantDependencies != null) {
            for (String constantDependency : constantDependencies) {
                Set<String> typesToRecompile = recompileDependencies.get(constantDependency);
                if (typesToRecompile == null) {
                    typesToRecompile = new HashSet<String>();
                    recompileDependencies.put(constantDependency, typesToRecompile);
                }
                typesToRecompile.add(typeToRecompile);
                Set<String> constantDeps = this.constantDependencies.get(constantDependency);
                if (alreadyVisited.contains(constantDependency) || constantDeps == null) continue;
                alreadyVisited.add(constantDependency);
                this.computeConstantRecompileDependencies(recompileDependencies, constantDeps, typeToRecompile, alreadyVisited);
            }
        }
    }

    private void computeHierarchyRecompileDependencies(@Nonnull Map<String, Set<String>> recompileDependencies, @CheckForNull Set<String> hierarchyDependencies, @Nonnull String typeToRecompile) {
        if (hierarchyDependencies != null) {
            for (String hierarchyDependency : hierarchyDependencies) {
                Set<String> typesToRecompile = recompileDependencies.get(hierarchyDependency);
                if (typesToRecompile == null) {
                    typesToRecompile = new HashSet<String>();
                    recompileDependencies.put(hierarchyDependency, typesToRecompile);
                }
                typesToRecompile.add(typeToRecompile);
                Set<String> newHierarchyDependencies = this.hierarchyDependencies.get(hierarchyDependency);
                if (newHierarchyDependencies == null) continue;
                this.computeHierarchyRecompileDependencies(recompileDependencies, newHierarchyDependencies, typeToRecompile);
            }
        }
    }

    @Override
    @Nonnull
    public void read(@Nonnull Readable readable) throws IOException {
        LineReader lr = new LineReader(readable);
        this.hierarchyDependencies = this.readMapOne2Many(lr);
        this.constantDependencies = this.readMapOne2Many(lr);
        this.codeDependencies = this.readMapOne2Many(lr);
    }

    public void update(@Nonnull FileDependencies fileDependencies, @Nonnull Set<String> deleteFileNames, @Nonnull Set<String> modifiedFileNames) {
        for (String deletedJavaFileName : deleteFileNames) {
            for (String deleteTypeName : fileDependencies.getTypeNames(deletedJavaFileName)) {
                this.codeDependencies.remove(deleteTypeName);
                this.constantDependencies.remove(deleteTypeName);
                this.hierarchyDependencies.remove(deleteTypeName);
            }
        }
        for (String modifiedJavaFileName : modifiedFileNames) {
            for (String deleteTypeName : fileDependencies.getTypeNames(modifiedJavaFileName)) {
                this.codeDependencies.remove(deleteTypeName);
                this.constantDependencies.remove(deleteTypeName);
                this.hierarchyDependencies.remove(deleteTypeName);
            }
        }
    }

    @Description(value="Type dependencies are collected")
    @Name(value="TypeDependencies.Collected")
    public static final class Collected
    implements Tag {
    }
}

