/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.analysis.dependency.file;

import com.android.jack.Jack;
import com.android.jack.analysis.dependency.file.FileDependencies;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import javax.annotation.Nonnull;

@Description(value="Collect dependencies between files and types")
@Name(value="FileDependenciesCollector")
@Transform(add={FileDependencies.Collected.class})
@Synchronized
@Filter(value={SourceTypeFilter.class})
public class FileDependenciesCollector
implements RunnableSchedulable<JDefinedClassOrInterface> {
    @Nonnull
    private final JSession session = Jack.getSession();

    @Override
    public synchronized void run(@Nonnull JDefinedClassOrInterface declaredType) {
        if (declaredType.getSourceInfo() == SourceInfo.UNKNOWN) {
            return;
        }
        this.session.getFileDependencies().addMappingBetweenJavaFileAndType(declaredType.getSourceInfo().getFileName(), declaredType);
    }
}

