/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.analysis;

import com.android.jack.Options;
import com.android.jack.analysis.DefinitionMarker;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JThis;
import com.android.jack.ir.ast.JVariableRef;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Remove definition marker on IR.")
@Constraint(need={DefinitionMarker.class})
@Transform(remove={DefinitionMarker.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class DefinitionMarkerRemover
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        Visitor visitor = new Visitor();
        visitor.accept(method);
    }

    private static class Visitor
    extends JVisitor {
        private Visitor() {
        }

        @Override
        public boolean visit(@Nonnull JMethod jmethod) {
            if (!jmethod.isStatic() && jmethod.getEnclosingType() instanceof JDefinedClass) {
                JThis thisVar = jmethod.getThis();
                assert (thisVar != null);
                thisVar.removeMarker(DefinitionMarker.class);
            }
            return super.visit(jmethod);
        }

        @Override
        public boolean visit(@Nonnull JParameter parameter) {
            parameter.removeMarker(DefinitionMarker.class);
            return super.visit(parameter);
        }

        @Override
        public boolean visit(@Nonnull JBinaryOperation binary) {
            JAsgOperation assign;
            if (binary instanceof JAsgOperation && (assign = (JAsgOperation)binary).getLhs() instanceof JVariableRef) {
                binary.removeMarker(DefinitionMarker.class);
            }
            return super.visit(binary);
        }
    }
}

