/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack;

import com.android.jack.IllegalOptionsException;
import com.android.jack.Jack;
import com.android.jack.JackIOException;
import com.android.jack.JackUserException;
import com.android.jack.Main;
import com.android.jack.backend.dex.DexFileWriter;
import com.android.jack.backend.dex.MultiDexLegacy;
import com.android.jack.backend.dex.compatibility.AndroidCompatibilityChecker;
import com.android.jack.backend.dex.rop.CodeItemBuilder;
import com.android.jack.config.id.Arzon;
import com.android.jack.config.id.Carnac;
import com.android.jack.config.id.JavaVersionPropertyId;
import com.android.jack.google.common.base.Joiner;
import com.android.jack.incremental.InputFilter;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.kohsuke.args4j.Argument;
import com.android.jack.kohsuke.args4j.Option;
import com.android.jack.kohsuke.args4j.spi.ExplicitBooleanOptionHandler;
import com.android.jack.kohsuke.args4j.spi.MapOptionHandler;
import com.android.jack.library.DumpInLibrary;
import com.android.jack.library.LibraryPathPropertyId;
import com.android.jack.library.PrebuiltCompatibility;
import com.android.jack.meta.MetaImporter;
import com.android.jack.plugin.JackPluginJarCodec;
import com.android.jack.plugin.NotJackPluginException;
import com.android.jack.plugin.PluginManager;
import com.android.jack.plugin.PluginNotFoundException;
import com.android.jack.reporting.Reportable;
import com.android.jack.reporting.Reporter;
import com.android.jack.resource.ResourceImporter;
import com.android.jack.shrob.obfuscation.MappingPrinter;
import com.android.jack.shrob.obfuscation.NameProviderFactory;
import com.android.jack.shrob.obfuscation.Renamer;
import com.android.jack.shrob.obfuscation.SourceFileRenamer;
import com.android.jack.shrob.obfuscation.annotation.AnnotationRemover;
import com.android.jack.shrob.obfuscation.annotation.ParameterAnnotationRemover;
import com.android.jack.shrob.seed.SeedPrinter;
import com.android.jack.shrob.spec.Flags;
import com.android.jack.transformations.lambda.LambdaGroupingScope;
import com.android.jack.transformations.renamepackage.PackageRenamer;
import com.android.jack.util.ClassNameCodec;
import com.android.jack.util.args4j.JackEnumOptionHandler;
import com.android.jack.util.filter.Filter;
import com.android.sched.reflections.ReflectionFactory;
import com.android.sched.util.HasDescription;
import com.android.sched.util.RunnableHooks;
import com.android.sched.util.SubReleaseKind;
import com.android.sched.util.codec.CaseInsensitiveDirectFSCodec;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.DirectDirOutputVFSCodec;
import com.android.sched.util.codec.DirectoryCodec;
import com.android.sched.util.codec.InputFileOrDirectoryCodec;
import com.android.sched.util.codec.ListCodec;
import com.android.sched.util.codec.PairCodec;
import com.android.sched.util.codec.PairListToMapCodecConverter;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.ReaderFileOrDirectoryCodec;
import com.android.sched.util.codec.StringValueCodec;
import com.android.sched.util.codec.VariableName;
import com.android.sched.util.codec.ZipFSCodec;
import com.android.sched.util.codec.ZipOutputVFSCodec;
import com.android.sched.util.config.Config;
import com.android.sched.util.config.ConfigurationException;
import com.android.sched.util.config.GatherConfigBuilder;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.PropertyIdException;
import com.android.sched.util.config.category.Private;
import com.android.sched.util.config.id.BooleanPropertyId;
import com.android.sched.util.config.id.EnumPropertyId;
import com.android.sched.util.config.id.ImplementationPropertyId;
import com.android.sched.util.config.id.IntegerPropertyId;
import com.android.sched.util.config.id.ListPropertyId;
import com.android.sched.util.config.id.ObjectId;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.config.id.ReflectFactoryPropertyId;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.FileUtils;
import com.android.sched.util.file.Files;
import com.android.sched.util.file.InputJarFile;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.OutputZipFile;
import com.android.sched.util.file.WriterFile;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.FileLocation;
import com.android.sched.util.location.Location;
import com.android.sched.util.location.NoLocation;
import com.android.sched.util.location.StringLocation;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.tracer.StatsTracerFtl;
import com.android.sched.vfs.Container;
import com.android.sched.vfs.OutputVFSPropertyId;
import com.android.sched.vfs.VFSPropertyId;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@HasKeyId
public class Options {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    public static final EnumPropertyId<AssertionPolicy> ASSERTION_POLICY = ((EnumPropertyId)EnumPropertyId.create((String)"jack.assert.policy", (String)"Assert statement policy", AssertionPolicy.class, (Enum[])AssertionPolicy.values()).addDefaultValue(AssertionPolicy.RUNTIME).ignoreCase().addCategory(DumpInLibrary.class)).addCategory(Carnac.class);
    @Nonnull
    public static final BooleanPropertyId INCREMENTAL_MODE = BooleanPropertyId.create("jack.incremental", "Enable incremental mode").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final ReflectFactoryPropertyId<InputFilter> INPUT_FILTER = ((ReflectFactoryPropertyId)ReflectFactoryPropertyId.create("jack.input.filter", "Inputs filter", InputFilter.class).addDefaultValue("no-filter")).addArgType(Options.class);
    @Nonnull
    public static final JavaVersionPropertyId JAVA_SOURCE_VERSION = ((JavaVersionPropertyId)JavaVersionPropertyId.create("jack.java.source.version", "Java source version").addDefaultValue("1.7").addCategory(Arzon.class)).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final BooleanPropertyId LAMBDA_TO_ANONYMOUS_CONVERTER = BooleanPropertyId.create("jack.lambda.anonymous", "Enable lambda support with an anonymous class").addDefaultValue(Boolean.TRUE).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final EnumPropertyId<LambdaGroupingScope> LAMBDA_GROUPING_SCOPE = ((EnumPropertyId)((EnumPropertyId)((EnumPropertyId)EnumPropertyId.create((String)"jack.lambda.grouping-scope", (String)"Defines the scope for lambda grouping", LambdaGroupingScope.class, (Enum[])LambdaGroupingScope.values()).ignoreCase().addDefaultValue(LambdaGroupingScope.NONE).requiredIf(LAMBDA_TO_ANONYMOUS_CONVERTER.getValue().isTrue())).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class)).addCategory(Private.class);
    @Nonnull
    public static final BooleanPropertyId LAMBDA_MERGE_INTERFACES = ((BooleanPropertyId)((BooleanPropertyId)BooleanPropertyId.create("jack.lambda.merge-interfaces", "Allows merging functional interfaces").addDefaultValue(Boolean.FALSE).requiredIf(LAMBDA_TO_ANONYMOUS_CONVERTER.getValue().isTrue()).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class)).addCategory(Private.class);
    @Nonnull
    public static final BooleanPropertyId LAMBDA_SIMPLIFY_STATELESS = ((BooleanPropertyId)((BooleanPropertyId)BooleanPropertyId.create("jack.lambda.simplify-stateless", "Simplifies stateless lambda to use single-instance implementation").addDefaultValue(Boolean.FALSE).requiredIf(LAMBDA_TO_ANONYMOUS_CONVERTER.getValue().isTrue()).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class)).addCategory(Private.class);
    @Nonnull
    public static final BooleanPropertyId GENERATE_JACK_LIBRARY = BooleanPropertyId.create("jack.library", "Generate jack library").addDefaultValue(Boolean.FALSE);
    @Nonnull
    public static final BooleanPropertyId GENERATE_DEX_FILE = BooleanPropertyId.create("jack.dex", "Generate dex file").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final EnumPropertyId<SwitchEnumOptStrategy> OPTIMIZED_ENUM_SWITCH = EnumPropertyId.create((String)"jack.optimization.enum.switch", (String)"Optimize enum switch", SwitchEnumOptStrategy.class, (Enum[])SwitchEnumOptStrategy.values()).addDefaultValue(SwitchEnumOptStrategy.NEVER).ignoreCase().addCategory(DumpInLibrary.class);
    @Nonnull
    public static final BooleanPropertyId GENERATE_DEX_IN_LIBRARY = BooleanPropertyId.create("jack.library.dex", "Generate dex files in library").addDefaultValue(Boolean.TRUE).requiredIf(GENERATE_JACK_LIBRARY.getValue().isTrue());
    @Nonnull
    public static final BooleanPropertyId USE_PREBUILT_FROM_LIBRARY = BooleanPropertyId.create("jack.library.prebuilt.use", "Use prebuilt files from library").addDefaultValue(Boolean.TRUE).requiredIf(GENERATE_DEX_FILE.getValue().isTrue().or(GENERATE_JACK_LIBRARY.getValue().isTrue())).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final BooleanPropertyId GENERATE_JAYCE_IN_LIBRARY = ((BooleanPropertyId)BooleanPropertyId.create("jack.library.jayce", "Generate Jayce files in library").addDefaultValue(Boolean.FALSE).addCategory(Private.class)).requiredIf(GENERATE_JACK_LIBRARY.getValue().isTrue());
    @Nonnull
    public static final BooleanPropertyId GENERATE_DEPENDENCIES_IN_LIBRARY = ((BooleanPropertyId)BooleanPropertyId.create("jack.library.dependencies", "Generate Dependency files in library").addDefaultValue(Boolean.FALSE).addCategory(Private.class)).requiredIf(GENERATE_JACK_LIBRARY.getValue().isTrue());
    @Nonnull
    public static final BooleanPropertyId GENERATE_LIBRARY_FROM_INCREMENTAL_FOLDER = BooleanPropertyId.create("jack.library.from-incremental-folder", "Generate a jack library from the incremental folder").addDefaultValue(Boolean.FALSE).addCategory(Private.class);
    @Nonnull
    public static final EnumPropertyId<Container> DEX_OUTPUT_CONTAINER_TYPE = EnumPropertyId.create((String)"jack.dex.output.container", (String)"Output container type", Container.class, (Enum[])Container.values()).ignoreCase().requiredIf(GENERATE_DEX_FILE.getValue().isTrue());
    @Nonnull
    public static final EnumPropertyId<Container> LIBRARY_OUTPUT_CONTAINER_TYPE = EnumPropertyId.create((String)"jack.library.output.container", (String)"Library output container type", Container.class, (Enum[])Container.values()).ignoreCase().requiredIf(GENERATE_JACK_LIBRARY.getValue().isTrue());
    @Nonnull
    public static final VFSPropertyId LIBRARY_OUTPUT_ZIP = VFSPropertyId.create("jack.library.output.zip", "Output zip archive for library", new ZipFSCodec(FileOrDirectory.Existence.MAY_EXIST, OutputZipFile.Compression.UNCOMPRESSED).setInfoString("output-lib")).withoutAutoAction().requiredIf(GENERATE_JACK_LIBRARY.getValue().isTrue().and(LIBRARY_OUTPUT_CONTAINER_TYPE.is(Container.ZIP)).or(GENERATE_LIBRARY_FROM_INCREMENTAL_FOLDER.getValue().isTrue()));
    @Nonnull
    public static final VFSPropertyId LIBRARY_OUTPUT_DIR = VFSPropertyId.create("jack.library.output.dir", "Output folder for library", new CaseInsensitiveDirectFSCodec(FileOrDirectory.Existence.MUST_EXIST).setInfoString("output-lib")).withoutAutoAction().requiredIf(GENERATE_JACK_LIBRARY.getValue().isTrue().and(LIBRARY_OUTPUT_CONTAINER_TYPE.is(Container.DIR)));
    @Nonnull
    public static final OutputVFSPropertyId DEX_OUTPUT_DIR = OutputVFSPropertyId.create("jack.dex.output.dir", "Output folder for dex", new DirectDirOutputVFSCodec(FileOrDirectory.Existence.MUST_EXIST).setInfoString("output-dex")).withoutAutoAction().requiredIf(DEX_OUTPUT_CONTAINER_TYPE.is(Container.DIR));
    @Nonnull
    public static final OutputVFSPropertyId DEX_OUTPUT_ZIP = OutputVFSPropertyId.create("jack.dex.output.zip", "Output zip archive for dex", new ZipOutputVFSCodec(FileOrDirectory.Existence.MAY_EXIST).setInfoString("output-dex")).requiredIf(DEX_OUTPUT_CONTAINER_TYPE.is(Container.ZIP));
    @Nonnull
    public static final LibraryPathPropertyId IMPORTED_LIBRARIES = new LibraryPathPropertyId("jack.library.import", "Libraries to import", "imported-lib").withoutAutoAction().addDefaultValue(Collections.emptyList());
    @Nonnull
    public static final LibraryPathPropertyId CLASSPATH = new LibraryPathPropertyId("jack.classpath", "Classpath", "classpath-lib").withoutAutoAction().on(File.pathSeparator).addDefaultValue(Collections.emptyList());
    @Nonnull
    public static final BooleanPropertyId ENABLE_COMPILED_FILES_STATISTICS = BooleanPropertyId.create("jack.statistic.source", "Enable compiled files statistics").addDefaultValue(Boolean.FALSE);
    @Nonnull
    public static final BooleanPropertyId ANNOTATION_PROCESSOR_ENABLED = BooleanPropertyId.create("jack.annotation-processor", "Enable annotation processors").addDefaultValue(true).addCategory(DumpInLibrary.class);
    @Option(name="--version", usage="display version")
    private boolean version;
    @Option(name="--help", usage="display help")
    private boolean help;
    @Option(name="--help-properties", usage="display properties list")
    private boolean helpProperties;
    @Option(name="-D", metaVar="<property>=<value>", usage="set value for the given property (repeatable)", handler=MapOptionHandler.class)
    @Nonnull
    private final Map<String, String> properties = new HashMap<String, String>();
    @Option(name="-A", metaVar="<option>=<value>", usage="set option for annotation processors (repeatable)", handler=MapOptionHandler.class)
    @CheckForNull
    private Map<String, String> annotationProcessorOption;
    @Nonnull
    public static final PropertyId<Map<String, String>> ANNOTATION_PROCESSOR_OPTIONS = PropertyId.create("jack.annotation-processor.options", "Options for annotation processors", new PairListToMapCodecConverter(new ListCodec(new PairCodec<String, String>(new StringValueCodec("an annotation processor option name", "option"), new StringValueCodec("an annotation processor option value", "value"))).setMin(0))).addDefaultValue(Collections.emptyMap());
    private final File propertiesFile = null;
    @Nonnull
    public static final EnumPropertyId<VerbosityLevel> VERBOSITY_LEVEL = EnumPropertyId.create((String)"jack.verbose.level", (String)"Verbosity level", VerbosityLevel.class, (Enum[])VerbosityLevel.values()).addDefaultValue(VerbosityLevel.WARNING);
    @Option(name="--verbose", usage="set verbosity (default: warning)", handler=JackEnumOptionHandler.class)
    private VerbosityLevel verbose = VerbosityLevel.WARNING;
    @Option(name="--incremental-folder", usage="directory used for incremental data", metaVar="<DIRECTORY>")
    private File incrementalFolder = null;
    @Option(name="--output-dex", usage="output dex files and resources to the directory", metaVar="<DIRECTORY>")
    private File out = null;
    @Option(name="--output-dex-zip", metaVar="<FILE>")
    private File outZip = null;
    @Option(name="--output-jack-dir", metaVar="<DIRECTORY>")
    private File libraryOutDir = null;
    @Option(name="--output-jack", usage="output jack library file", metaVar="<FILE>")
    private File libraryOutZip = null;
    @Option(name="--config-jarjar", usage="use jarjar rules files (default: none)", metaVar="<FILE>")
    private List<File> jarjarRulesFiles = new ArrayList<File>(0);
    @Option(name="--import", usage="import the given file into the output (repeatable)", metaVar="<FILE>")
    protected List<File> importedLibraries = new ArrayList<File>();
    @Option(name="--import-resource", usage="import the given directory into the output as resource files (repeatable)", metaVar="<DIRECTORY>")
    private List<File> resImport = new ArrayList<File>();
    @Option(name="--import-meta", usage="import the given directory into the output as meta-files (repeatable)", metaVar="<DIRECTORY>")
    private List<File> metaImport = new ArrayList<File>();
    @Option(name="--config-proguard", usage="use a proguard flags file (default: none) (repeatable)", metaVar="<FILE>")
    protected List<File> proguardFlagsFiles = null;
    @Option(name="--sanity-checks", handler=ExplicitBooleanOptionHandler.class, metaVar="[on | off]")
    private boolean sanityChecks = Jack.getVersion().getSubReleaseKind() == SubReleaseKind.ENGINEERING;
    @Nonnull
    public static final BooleanPropertyId SANITY_CHECKS = ((BooleanPropertyId)BooleanPropertyId.create("jack.sanity-checks", "Compiler sanity checks").addCategory(DumpInLibrary.class)).addDefaultValue(Jack.getVersion().getSubReleaseKind() == SubReleaseKind.ENGINEERING);
    @Option(name="--tracer-dir", metaVar="<DIRECTORY>")
    private File tracerDir;
    @Option(name="--processorpath", usage="annotation processor classpath", metaVar="<PATH>")
    @CheckForNull
    private String processorPath;
    @Option(name="--processor", usage="annotation processor class names", metaVar="<NAME>[,<NAME>...]")
    @CheckForNull
    private String processor;
    @Nonnull
    public static final BooleanPropertyId ANNOTATION_PROCESSOR_MANUAL = BooleanPropertyId.create("jack.annotation-processor.manual", "run only specified annotation processors").addDefaultValue(false).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final ListPropertyId<String> ANNOTATION_PROCESSOR_MANUAL_LIST = new ListPropertyId<String>("jack.annotation-processor.manual.list", "Annotation processor class names", new ClassNameCodec()).minElements(0).requiredIf(ANNOTATION_PROCESSOR_MANUAL.getValue().isTrue());
    @Nonnull
    public static final PropertyId<Directory> ANNOTATION_PROCESSOR_SOURCE_OUTPUT_DIR = PropertyId.create("jack.annotation-processor.source.output", "Output folder for sources generated by annotation processors", new DirectoryCodec(FileOrDirectory.Existence.MUST_EXIST, 3));
    @Nonnull
    public static final PropertyId<Directory> ANNOTATION_PROCESSOR_CLASS_OUTPUT_DIR = PropertyId.create("jack.annotation-processor.class.output", "Output folder for classes generated by annotation processors", new DirectoryCodec(FileOrDirectory.Existence.MUST_EXIST, 3));
    @Nonnull
    public static final BooleanPropertyId ANNOTATION_PROCESSOR_PATH = BooleanPropertyId.create("jack.annotation-processor.path", "Use annotation processor classpath for annotation processor loading").addDefaultValue(false);
    @Nonnull
    public static final ListPropertyId<FileOrDirectory> ANNOTATION_PROCESSOR_PATH_LIST = new ListPropertyId<FileOrDirectory>("jack.annotation-processor.path.list", "Annotation processor classpath", new InputFileOrDirectoryCodec()).on(File.pathSeparator).minElements(0).requiredIf(ANNOTATION_PROCESSOR_PATH.getValue().isTrue());
    @Nonnull
    public static final BooleanPropertyId USE_DEFAULT_LIBRARIES = BooleanPropertyId.create("jack.classpath.default-libraries", "Use default libraries as first classpath entries").addDefaultValue(Boolean.TRUE).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final ListPropertyId<FileOrDirectory> SOURCE_PATH = new ListPropertyId<FileOrDirectory>("jack.source.path", "Source path", new InputFileOrDirectoryCodec()).on(File.pathSeparator).minElements(0).addDefaultValue(Collections.emptyList());
    @Nonnull
    @Option(name="-cp", aliases={"--classpath"}, usage="set classpath", metaVar="<PATH>")
    protected String classpath = "";
    @Argument(usage="read command line from file", metaVar="@<FILE>")
    @CheckForNull
    protected List<File> inputSources;
    @Nonnull
    public static final ListPropertyId<FileOrDirectory> SOURCES = new ListPropertyId<FileOrDirectory>("jack.source", "Sources to compile", new ReaderFileOrDirectoryCodec()).on(File.pathSeparator).minElements(0).addDefaultValue(Collections.emptyList());
    @Nonnull
    private final List<String> ecjExtraArguments = new ArrayList<String>();
    @Option(name="-g", usage="emit debug infos")
    private Boolean emitLocalDebugInfo;
    @Option(name="--multi-dex", usage="whether to split code into multiple dex files (default: none)", handler=JackEnumOptionHandler.class)
    private MultiDexKind multiDexKind = MultiDexKind.NONE;
    @Nonnull
    public static final BooleanPropertyId OPTIMIZE_INNER_CLASSES_ACCESSORS = BooleanPropertyId.create("jack.optimization.inner-class.accessors", "Avoid creating synthethic accessors for outer class private fields and methods").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final BooleanPropertyId OPTIMIZE_TAIL_RECURSION = BooleanPropertyId.create("jack.optimization.tail-recursion", "Optimize tail recursive calls").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final BooleanPropertyId EMIT_LOCAL_DEBUG_INFO = BooleanPropertyId.create("jack.dex.debug.vars", "Emit local variable debug info into generated dex").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final BooleanPropertyId EMIT_LINE_NUMBER_DEBUG_INFO = BooleanPropertyId.create("jack.dex.debug.lines", "Emit line number debug info into generated dex").addDefaultValue(Boolean.TRUE).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final BooleanPropertyId EMIT_SOURCE_FILE_DEBUG_INFO = BooleanPropertyId.create("jack.dex.debug.source", "Emit source file debug info into generated dex").addDefaultValue(Boolean.TRUE).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final IntegerPropertyId ANDROID_MIN_API_LEVEL = ((IntegerPropertyId)((IntegerPropertyId)IntegerPropertyId.create("jack.android.min-api-level", "Minimum Android API level compatibility").withMin(1L).addDefaultValue(1).addCategory(DumpInLibrary.class)).addCategory(Carnac.class)).addCategory(new PrebuiltCompatibility(){

        @Override
        public boolean isCompatible(@Nonnull Config config, @Nonnull String valueFromLibrary) throws ParsingException {
            return config.parseAs(valueFromLibrary, ANDROID_MIN_API_LEVEL) <= config.get(ANDROID_MIN_API_LEVEL);
        }
    });
    @Nonnull
    public static final BooleanPropertyId DROP_METHOD_BODY = BooleanPropertyId.create("jack.internal.dropmethodbody", "Drop method bodies when they are no longer useful").addDefaultValue(Boolean.TRUE);
    @Nonnull
    public static final BooleanPropertyId SHROB_ENABLED = BooleanPropertyId.create("jack.shrob", "Enable shrink and obfuscation features").addDefaultValue(false).addCategory(DumpInLibrary.class);
    @CheckForNull
    protected Flags flags = null;
    @Nonnull
    public static final ObjectId<Flags> FLAGS = new ObjectId<Flags>("jack.shrob.flags", Flags.class);
    @Nonnull
    public static final BooleanPropertyId USE_MIXED_CASE_CLASSNAME = BooleanPropertyId.create("jack.obfuscation.mixedcaseclassname", "Use mixed case class name when obfuscating").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final ImplementationPropertyId<Filter<JMethod>> METHOD_FILTER = (ImplementationPropertyId)ImplementationPropertyId.create("jack.internal.filter.method", "Define which filter will be used for methods", Filter.class).addDefaultValue("all-methods");
    @CheckForNull
    private OutputStream reporterStream = null;
    @CheckForNull
    private File workingDirectory = null;
    @CheckForNull
    private PrintStream standardError = null;
    @CheckForNull
    private PrintStream standardOutput = null;
    @CheckForNull
    private Charset defaultCharset = null;
    @CheckForNull
    private CodecContext codecContext = null;
    @Option(name="--list-plugins", usage="display all available plugins")
    private boolean listPlugins;
    @Option(name="--pluginpath", usage="jack plugin classpath", metaVar="<PATH>")
    @Nonnull
    private String pluginPath = "";
    @Option(name="--plugin", usage="jack plugin names", metaVar="<NAME>[,<NAME>...] (unique)")
    @Nonnull
    private String pluginNames = "";
    @CheckForNull
    private PluginManager pluginManager = null;
    @Nonnull
    public static final ListCodec<InputJarFile> PLUGIN_PATH_CODEC = new ListCodec<InputJarFile>(new JackPluginJarCodec()).setSeparator(File.pathSeparator);
    @Nonnull
    public static final ListCodec<String> PLUGIN_NAMES_CODEC = new ListCodec<String>(new StringValueCodec("a Jack plugin name", "plugin")).setSeparator(",").ensureUnicity();
    @CheckForNull
    private Config config = null;

    public void setWorkingDirectory(@Nonnull File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setStandardError(@Nonnull PrintStream standardError) {
        this.standardError = standardError;
    }

    public void setStandardOutput(@Nonnull PrintStream standardOutput) {
        this.standardOutput = standardOutput;
    }

    public void setDefaultCharset(@Nonnull Charset charset) {
        this.defaultCharset = charset;
    }

    @Nonnull
    private synchronized CodecContext getCondecContext() throws IllegalOptionsException {
        if (this.codecContext == null) {
            this.codecContext = new CodecContext();
            if (this.workingDirectory != null) {
                try {
                    this.codecContext.setWorkingDirectory(this.workingDirectory);
                }
                catch (NotDirectoryException e) {
                    throw new IllegalOptionsException(e.getMessage(), e);
                }
                catch (WrongPermissionException e) {
                    throw new IllegalOptionsException(e.getMessage(), e);
                }
                catch (NoSuchFileException e) {
                    throw new IllegalOptionsException(e.getMessage(), e);
                }
            }
            if (this.standardError != null) {
                this.codecContext.setStandardError(this.standardError);
            }
            if (this.standardOutput != null) {
                this.codecContext.setStandardOutput(this.standardOutput);
            }
            if (this.defaultCharset != null) {
                this.codecContext.setDefaultCharset(this.defaultCharset);
            }
            if (this.sanityChecks) {
                this.codecContext.setDebug();
            }
        }
        assert (this.codecContext != null);
        return this.codecContext;
    }

    public void setPluginPath(@CheckForNull String pluginPath) {
        this.pluginPath = pluginPath == null ? "" : pluginPath;
    }

    public void setPluginNames(@Nonnull String pluginNames) {
        this.pluginNames = pluginNames;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void ensurePluginManager() throws IllegalOptionsException {
        if (this.pluginManager != null) return;
        try {
            Object jars = PLUGIN_PATH_CODEC.checkString(this.getCondecContext(), this.pluginPath);
            if (jars == null) {
                jars = PLUGIN_PATH_CODEC.parseString(this.getCondecContext(), this.pluginPath);
            }
            this.pluginManager = new PluginManager();
            try {
                Iterator iterator = jars.iterator();
                while (iterator.hasNext()) {
                    InputJarFile jar = (InputJarFile)iterator.next();
                    this.pluginManager.addPlugin(new URL[]{jar.getFile().toURI().toURL()});
                }
            }
            catch (NotJackPluginException | MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        catch (ParsingException e) {
            throw new IllegalOptionsException("option --pluginpath: " + e.getMessage(), e);
        }
        try {
            Object names = PLUGIN_NAMES_CODEC.checkString(this.getCondecContext(), this.pluginNames);
            if (names == null) {
                names = PLUGIN_NAMES_CODEC.parseString(this.getCondecContext(), this.pluginNames);
            }
            Iterator iterator = names.iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                try {
                    assert (this.pluginManager != null);
                    this.pluginManager.loadPlugin(name);
                }
                catch (PluginNotFoundException e) {
                    throw new IllegalOptionsException("option --plugin: " + e.getMessage(), e);
                    return;
                }
            }
        }
        catch (ParsingException e) {
            throw new IllegalOptionsException("option --plugin: " + e.getMessage(), e);
        }
    }

    @Nonnull
    public synchronized PluginManager getPluginManager() {
        assert (this.pluginManager != null);
        return this.pluginManager;
    }

    public void setVerbosityLevel(@Nonnull VerbosityLevel verbose) {
        this.verbose = verbose;
    }

    public boolean askForVersion() {
        return this.version;
    }

    public boolean askForHelp() {
        return this.help;
    }

    public boolean askForPropertiesHelp() {
        return this.helpProperties;
    }

    public boolean askForPluginsList() {
        return this.listPlugins;
    }

    public void setInputSources(@Nonnull Collection<File> inputSources) {
        this.inputSources = new ArrayList<File>(inputSources);
    }

    public void setOutputDir(File out) {
        this.out = out;
    }

    public void setOutputZip(File out) {
        this.outZip = out;
    }

    @Nonnull
    public Config getConfig() {
        assert (this.config != null);
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public GatherConfigBuilder getDefaultConfigBuilder() throws IOException, IllegalOptionsException {
        this.ensurePluginManager();
        GatherConfigBuilder configBuilder = new GatherConfigBuilder(this.sanityChecks, this.getPluginManager().getReflectionManager(ReflectionFactory.getManager()));
        assert (this.codecContext != null);
        configBuilder.setCodecContext(this.codecContext);
        String resourceName = "/config.properties";
        InputStream is = Main.class.getResourceAsStream(resourceName);
        if (is != null) {
            try {
                configBuilder.load(is, new StringLocation("resource " + resourceName));
            }
            finally {
                is.close();
            }
        }
        return configBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public GatherConfigBuilder getConfigBuilder(@Nonnull RunnableHooks hooks) throws IllegalOptionsException {
        GatherConfigBuilder configBuilder;
        block68: {
            if (this.propertiesFile != null) {
                if (!this.propertiesFile.exists()) {
                    throw new IllegalOptionsException("The specified config file '" + this.propertiesFile.getPath() + "' does not exist.");
                }
                if (!this.propertiesFile.isFile()) {
                    throw new IllegalOptionsException("The specified config file '" + this.propertiesFile.getPath() + "' is not a file.");
                }
                if (!this.propertiesFile.canRead()) {
                    throw new IllegalOptionsException("The specified config file '" + this.propertiesFile.getPath() + "' cannot be read.");
                }
                this.ensurePluginManager();
                configBuilder = new GatherConfigBuilder(this.sanityChecks, this.getPluginManager().getReflectionManager(ReflectionFactory.getManager()));
                configBuilder.setCodecContext(this.getCondecContext());
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.propertiesFile));){
                    configBuilder.load(is, new FileLocation(this.propertiesFile));
                    break block68;
                }
                catch (FileNotFoundException e) {
                    throw new AssertionError();
                }
                catch (IOException e) {
                    throw new IllegalOptionsException("The specified config file '" + this.propertiesFile.getPath() + "' cannot be read.", e.getCause());
                }
            }
            try {
                configBuilder = this.getDefaultConfigBuilder();
            }
            catch (IOException e) {
                throw new IllegalOptionsException(e.getMessage(), e);
            }
        }
        configBuilder.pushDefaultLocation(new StringLocation("Options"));
        configBuilder.set(VERBOSITY_LEVEL, this.verbose);
        if (this.reporterStream != null) {
            configBuilder.set(Reporter.REPORTER_WRITER, new WriterFile(this.reporterStream, new NoLocation()));
        }
        if (!this.jarjarRulesFiles.isEmpty()) {
            configBuilder.set(PackageRenamer.JARJAR_ENABLED, true);
            String sep = ((ListCodec)PackageRenamer.JARJAR_FILES.getCodec()).getSeparator();
            configBuilder.setString(PackageRenamer.JARJAR_FILES, Joiner.on(sep).join(this.jarjarRulesFiles));
            configBuilder.set(USE_PREBUILT_FROM_LIBRARY, false);
            logger.log(Level.WARNING, "Prebuilts from libraries are not used due to usage of jarjar");
        }
        if (this.processor != null) {
            configBuilder.set(ANNOTATION_PROCESSOR_MANUAL, true);
            configBuilder.setString(ANNOTATION_PROCESSOR_MANUAL_LIST, this.processor);
        }
        configBuilder.set(ANNOTATION_PROCESSOR_SOURCE_OUTPUT_DIR, Options.createTempDir(hooks));
        Directory annotationProcessorOutputClasses = Options.createTempDir(hooks);
        configBuilder.set(ANNOTATION_PROCESSOR_CLASS_OUTPUT_DIR, annotationProcessorOutputClasses);
        this.addResource(annotationProcessorOutputClasses.getFile());
        if (this.processorPath != null) {
            configBuilder.set(ANNOTATION_PROCESSOR_PATH, true);
            configBuilder.setString(ANNOTATION_PROCESSOR_PATH_LIST, this.processorPath);
        }
        if (this.annotationProcessorOption != null) {
            configBuilder.set(ANNOTATION_PROCESSOR_OPTIONS, this.annotationProcessorOption);
        }
        if (!this.resImport.isEmpty()) {
            configBuilder.setString(ResourceImporter.IMPORTED_RESOURCES, Joiner.on(File.pathSeparator).join(this.resImport));
        }
        if (!this.metaImport.isEmpty()) {
            configBuilder.setString(MetaImporter.IMPORTED_META, Joiner.on(File.pathSeparator).join(this.metaImport));
        }
        if (this.inputSources != null && !this.inputSources.isEmpty()) {
            configBuilder.setString(SOURCES, Joiner.on(File.pathSeparator).join(this.inputSources));
        }
        if (this.emitLocalDebugInfo != null) {
            configBuilder.set(EMIT_LOCAL_DEBUG_INFO, this.emitLocalDebugInfo);
        }
        configBuilder.pushDefaultLocation(new StringLocation("proguard flags"));
        if (this.flags != null) {
            String packageForRenamedPackages;
            String packageForRenamedClasses;
            File dictionary;
            configBuilder.set(SHROB_ENABLED, true);
            configBuilder.set(USE_PREBUILT_FROM_LIBRARY, false);
            logger.log(Level.WARNING, "Prebuilts from libraries are not used due to usage of shrinking or obfuscation");
            if (this.flags.obfuscate()) {
                boolean emitRuntimeInvisibleAnnotation = this.flags.keepAttribute("RuntimeInvisibleAnnotations");
                configBuilder.set(AnnotationRemover.EMIT_SOURCE_RETENTION_ANNOTATION, emitRuntimeInvisibleAnnotation);
                configBuilder.set(AnnotationRemover.EMIT_CLASS_RETENTION_ANNOTATION, emitRuntimeInvisibleAnnotation);
                configBuilder.set(AnnotationRemover.EMIT_RUNTIME_RETENTION_ANNOTATION, this.flags.keepAttribute("RuntimeVisibleAnnotations"));
                boolean emitRuntimeInvisibleParameterAnnotation = this.flags.keepAttribute("RuntimeInvisibleParameterAnnotations");
                configBuilder.set(ParameterAnnotationRemover.EMIT_SOURCE_RETENTION_PARAMETER_ANNOTATION, emitRuntimeInvisibleParameterAnnotation);
                configBuilder.set(ParameterAnnotationRemover.EMIT_CLASS_RETENTION_PARAMETER_ANNOTATION, emitRuntimeInvisibleParameterAnnotation);
                configBuilder.set(ParameterAnnotationRemover.EMIT_RUNTIME_RETENTION_PARAMETER_ANNOTATION, this.flags.keepAttribute("RuntimeVisibleParameterAnnotations"));
                configBuilder.set(EMIT_LINE_NUMBER_DEBUG_INFO, this.flags.keepAttribute("LineNumberTable"));
                configBuilder.set(EMIT_LOCAL_DEBUG_INFO, this.flags.keepAttribute("LocalVariableTable"));
            }
            configBuilder.set(FLAGS, this.flags);
            configBuilder.set(USE_MIXED_CASE_CLASSNAME, this.flags.getUseMixedCaseClassName());
            configBuilder.set(Renamer.USE_UNIQUE_CLASSMEMBERNAMES, this.flags.getUseUniqueClassMemberNames());
            File mapping = this.flags.getObfuscationMapping();
            if (mapping != null) {
                configBuilder.set(Renamer.USE_MAPPING, true);
                configBuilder.setString(Renamer.MAPPING_FILE, mapping.getPath());
            } else {
                configBuilder.set(Renamer.USE_MAPPING, false);
            }
            File seeds = this.flags.getSeedsFile();
            if (seeds != null) {
                configBuilder.setString(SeedPrinter.SEEDS_OUTPUT_FILE, seeds.getPath());
            }
            if ((dictionary = this.flags.getObfuscationDictionary()) != null) {
                configBuilder.set(Renamer.USE_OBFUSCATION_DICTIONARY, true);
                configBuilder.setString(Renamer.OBFUSCATION_DICTIONARY, dictionary.getPath());
            } else {
                configBuilder.set(Renamer.USE_OBFUSCATION_DICTIONARY, false);
            }
            File classDictionary = this.flags.getClassObfuscationDictionary();
            if (classDictionary != null) {
                configBuilder.set(Renamer.USE_CLASS_OBFUSCATION_DICTIONARY, true);
                configBuilder.setString(Renamer.CLASS_OBFUSCATION_DICTIONARY, classDictionary.getPath());
            } else {
                configBuilder.set(Renamer.USE_CLASS_OBFUSCATION_DICTIONARY, false);
            }
            File packageDictionary = this.flags.getPackageObfuscationDictionary();
            if (packageDictionary != null) {
                configBuilder.set(Renamer.USE_PACKAGE_OBFUSCATION_DICTIONARY, true);
                configBuilder.setString(Renamer.PACKAGE_OBFUSCATION_DICTIONARY, packageDictionary.getPath());
            } else {
                configBuilder.set(Renamer.USE_PACKAGE_OBFUSCATION_DICTIONARY, false);
            }
            configBuilder.set(MappingPrinter.MAPPING_OUTPUT_ENABLED, this.flags.printMapping());
            File outputmapping = this.flags.getOutputMapping();
            if (outputmapping != null) {
                configBuilder.setString(MappingPrinter.MAPPING_OUTPUT_FILE, outputmapping.getPath());
            }
            if (this.flags.getUseMixedCaseClassName()) {
                configBuilder.setString(NameProviderFactory.NAMEPROVIDER, "mixed-case");
            }
            if ((packageForRenamedClasses = this.flags.getPackageForRenamedClasses()) != null) {
                configBuilder.set(Renamer.REPACKAGE_CLASSES, true);
                configBuilder.set(Renamer.PACKAGE_FOR_RENAMED_CLASSES, packageForRenamedClasses);
                if (this.flags.getPackageForFlatHierarchy() != null) {
                    throw new IllegalOptionsException("Flatten package and repackage classes cannot be used simultaneously");
                }
            } else {
                configBuilder.set(Renamer.REPACKAGE_CLASSES, false);
            }
            if ((packageForRenamedPackages = this.flags.getPackageForFlatHierarchy()) != null) {
                configBuilder.set(Renamer.FLATTEN_PACKAGE, true);
                configBuilder.set(Renamer.PACKAGE_FOR_RENAMED_PACKAGES, packageForRenamedPackages);
            } else {
                configBuilder.set(Renamer.FLATTEN_PACKAGE, false);
            }
            String renameSourceFileAttribute = this.flags.getRenameSourceFileAttribute();
            if (renameSourceFileAttribute != null) {
                configBuilder.set(SourceFileRenamer.RENAME_SOURCEFILE, true);
                configBuilder.set(SourceFileRenamer.NEW_SOURCEFILE_NAME, new File(renameSourceFileAttribute));
            } else {
                configBuilder.set(SourceFileRenamer.RENAME_SOURCEFILE, false);
            }
        }
        configBuilder.popDefaultLocation();
        if (this.importedLibraries != null) {
            configBuilder.setString(IMPORTED_LIBRARIES, Joiner.on(',').join(this.importedLibraries));
        }
        if (this.classpath != null) {
            configBuilder.setString(CLASSPATH, this.classpath);
        }
        if (this.libraryOutZip != null) {
            configBuilder.setString(LIBRARY_OUTPUT_ZIP, this.libraryOutZip.getPath());
            configBuilder.set(LIBRARY_OUTPUT_CONTAINER_TYPE, Container.ZIP);
            configBuilder.set(GENERATE_JACK_LIBRARY, true);
            configBuilder.set(GENERATE_JAYCE_IN_LIBRARY, true);
            configBuilder.set(GENERATE_DEPENDENCIES_IN_LIBRARY, true);
        } else if (this.libraryOutDir != null) {
            configBuilder.setString(LIBRARY_OUTPUT_DIR, this.libraryOutDir.getPath());
            configBuilder.set(LIBRARY_OUTPUT_CONTAINER_TYPE, Container.DIR);
            configBuilder.set(GENERATE_JACK_LIBRARY, true);
            configBuilder.set(GENERATE_JAYCE_IN_LIBRARY, true);
            configBuilder.set(GENERATE_DEPENDENCIES_IN_LIBRARY, true);
        } else {
            configBuilder.setString(LIBRARY_OUTPUT_DIR, Options.createTempDir(hooks).getPath());
            configBuilder.set(LIBRARY_OUTPUT_CONTAINER_TYPE, Container.DIR);
            configBuilder.set(GENERATE_JACK_LIBRARY, true);
        }
        switch (this.multiDexKind) {
            case NATIVE: {
                configBuilder.setString(DexFileWriter.DEX_WRITING_POLICY, "multidex");
                break;
            }
            case LEGACY: {
                configBuilder.setString(DexFileWriter.DEX_WRITING_POLICY, "multidex");
                configBuilder.set(MultiDexLegacy.MULTIDEX_LEGACY, true);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported multi dex kind: '" + this.multiDexKind.name() + "'"));
            }
        }
        if (this.outZip != null) {
            configBuilder.setString(DEX_OUTPUT_ZIP, this.outZip.getPath());
            configBuilder.set(DEX_OUTPUT_CONTAINER_TYPE, Container.ZIP);
            configBuilder.set(GENERATE_DEX_FILE, true);
            configBuilder.set(AndroidCompatibilityChecker.CHECK_COMPATIBILITY, true);
        } else if (this.out != null) {
            configBuilder.setString(DEX_OUTPUT_DIR, this.out.getPath());
            configBuilder.set(DEX_OUTPUT_CONTAINER_TYPE, Container.DIR);
            configBuilder.set(GENERATE_DEX_FILE, true);
            configBuilder.set(AndroidCompatibilityChecker.CHECK_COMPATIBILITY, true);
        }
        boolean isIncrementalEnabled = false;
        if (this.incrementalFolder != null) {
            if (this.multiDexKind == MultiDexKind.LEGACY) {
                logger.log(Level.WARNING, "Incremental mode is disabled due to multi-dex legacy mode");
            } else if (this.flags != null) {
                logger.log(Level.WARNING, "Incremental mode is disabled due to usage of shrinking or obfuscation");
            } else if (!this.jarjarRulesFiles.isEmpty()) {
                logger.log(Level.WARNING, "Incremental mode is disabled due to usage of jarjar");
            } else if (this.properties.containsKey(SOURCE_PATH.getName())) {
                logger.log(Level.WARNING, "Incremental mode is disabled due to usage of source path");
            } else {
                configBuilder.set(INCREMENTAL_MODE, true);
                configBuilder.setString(INPUT_FILTER, "incremental");
                configBuilder.set(GENERATE_JACK_LIBRARY, true);
                configBuilder.set(GENERATE_JAYCE_IN_LIBRARY, true);
                configBuilder.set(GENERATE_DEPENDENCIES_IN_LIBRARY, true);
                configBuilder.setString(LIBRARY_OUTPUT_CONTAINER_TYPE, "dir");
                configBuilder.setString(LIBRARY_OUTPUT_DIR, this.incrementalFolder.getPath());
                if (this.libraryOutZip != null) {
                    configBuilder.set(GENERATE_LIBRARY_FROM_INCREMENTAL_FOLDER, true);
                }
                isIncrementalEnabled = true;
            }
        }
        if (this.tracerDir != null) {
            configBuilder.setString(TracerFactory.TRACER, "html");
            configBuilder.setString(StatsTracerFtl.TRACER_DIR, this.tracerDir.getPath());
        }
        configBuilder.set(SANITY_CHECKS, this.sanityChecks);
        configBuilder.popDefaultLocation();
        configBuilder.setString(CLASSPATH, this.classpath);
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            configBuilder.setString(entry.getKey(), entry.getValue(), (Location)new StringLocation("-D option"));
        }
        if (isIncrementalEnabled) {
            configBuilder.set(OPTIMIZED_ENUM_SWITCH.getName(), SwitchEnumOptStrategy.NEVER);
        }
        configBuilder.processEnvironmentVariables("JACK_CONFIG_");
        configBuilder.setHooks(hooks);
        return configBuilder;
    }

    public void checkValidity(@Nonnull RunnableHooks hooks) throws IllegalOptionsException, ConfigurationException {
        this.ecjExtraArguments.clear();
        Config config = this.config = this.getConfigBuilder(hooks).build();
        assert (config != null);
        assert (config != null);
        if (this.inputSources != null) {
            if (config.get(VERBOSITY_LEVEL) == VerbosityLevel.ERROR) {
                this.ecjExtraArguments.add(0, "-nowarn");
            }
            this.ecjExtraArguments.add("-source");
            this.ecjExtraArguments.add(config.get(JAVA_SOURCE_VERSION).toString());
            if (!config.get(ANNOTATION_PROCESSOR_ENABLED).booleanValue()) {
                this.ecjExtraArguments.add("-proc:none");
            }
        }
        if (config.get(CodeItemBuilder.EMIT_SYNTHETIC_LOCAL_DEBUG_INFO).booleanValue() && !config.get(EMIT_LOCAL_DEBUG_INFO).booleanValue()) {
            throw new PropertyIdException(CodeItemBuilder.EMIT_SYNTHETIC_LOCAL_DEBUG_INFO, (Location)new NoLocation(), "Impossible to emit synthetic debug info when not emitting debug info");
        }
        if (this.verbose == VerbosityLevel.DEBUG || this.verbose == VerbosityLevel.TRACE) {
            config.get(Reporter.REPORTER).report(Reporter.Severity.NON_FATAL, new DeprecatedVerbosity(this.verbose));
        }
    }

    public void setJayceOutputDir(@Nonnull File outputDir) {
        this.libraryOutDir = outputDir;
    }

    public void setJayceOutputZip(@Nonnull File outputZip) {
        this.libraryOutZip = outputZip;
    }

    public void setImportedLibraries(@Nonnull List<File> importedLibraries) {
        this.importedLibraries = importedLibraries;
    }

    @CheckForNull
    public Flags getFlags() {
        return this.flags;
    }

    public void setFlags(@Nonnull Flags flags) {
        this.flags = flags;
    }

    public void applyShrobFlags() {
        String libraryJars;
        List<File> outJars;
        assert (this.flags != null);
        List<File> inJars = this.flags.getInJars();
        if (inJars.size() > 0) {
            this.importedLibraries = new ArrayList<File>(inJars.size());
            this.importedLibraries.addAll(inJars);
        }
        if ((outJars = this.flags.getOutJars()).size() > 0) {
            File outJar = outJars.get(0);
            if (outJar.isDirectory()) {
                this.libraryOutDir = outJar;
            } else {
                this.libraryOutZip = outJar;
            }
        }
        if ((libraryJars = this.flags.getLibraryJars()) != null) {
            this.classpath = this.classpath.isEmpty() ? libraryJars : this.classpath + File.pathSeparatorChar + libraryJars;
        }
    }

    public void setClasspath(@CheckForNull String classpath) {
        this.classpath = classpath == null ? "" : classpath;
    }

    public void setMultiDexKind(@Nonnull MultiDexKind multiDexKind) {
        this.multiDexKind = multiDexKind;
    }

    public void addProguardFlagsFile(@Nonnull File flags) {
        if (this.proguardFlagsFiles == null) {
            this.proguardFlagsFiles = new ArrayList<File>();
        }
        this.proguardFlagsFiles.add(flags);
    }

    public void addProperty(@Nonnull String propertyName, @Nonnull String propertyValue) {
        this.properties.put(propertyName, propertyValue);
    }

    @Nonnull
    List<String> getEcjExtraArguments() {
        return this.ecjExtraArguments;
    }

    public void setProguardFlagsFile(@Nonnull List<File> proguardFlagsFiles) {
        this.proguardFlagsFiles = proguardFlagsFiles;
    }

    public void setJarjarRulesFiles(@Nonnull List<File> jarjarRulesFiles) {
        this.jarjarRulesFiles = jarjarRulesFiles;
    }

    public void disableDxOptimizations() {
        this.properties.put(CodeItemBuilder.DEX_OPTIMIZE.getName(), "false");
    }

    public void setSanityChecks(boolean sanityChecks) {
        this.sanityChecks = sanityChecks;
    }

    public void setIncrementalFolder(@Nonnull File incrementalFolder) {
        this.incrementalFolder = incrementalFolder;
    }

    public void addResource(@Nonnull File resource) {
        this.resImport.add(resource);
    }

    public void setResourceDirs(@Nonnull List<File> resourceDirs) {
        this.resImport = new ArrayList<File>(resourceDirs);
    }

    public void setMetaDirs(@Nonnull List<File> metaDirs) {
        this.metaImport = metaDirs;
    }

    public void setReporterStream(@Nonnull OutputStream reporterStream) {
        this.reporterStream = reporterStream;
    }

    public List<File> getProguardFlagsFile() {
        ArrayList<File> proguardFlagsFileFromWorkingDir = new ArrayList<File>(this.proguardFlagsFiles.size());
        for (File proguardFlagsFile : this.proguardFlagsFiles) {
            if (this.workingDirectory != null && !proguardFlagsFile.isAbsolute()) {
                proguardFlagsFileFromWorkingDir.add(new File(this.workingDirectory, proguardFlagsFile.getPath()));
                continue;
            }
            proguardFlagsFileFromWorkingDir.add(proguardFlagsFile);
        }
        return proguardFlagsFileFromWorkingDir;
    }

    @Nonnull
    private static Directory createTempDir(@Nonnull RunnableHooks hooks) {
        try {
            File tmp = Files.createTempDir("jack-");
            Directory dir = new Directory(tmp.getPath(), hooks, FileOrDirectory.Existence.MUST_EXIST, 2, FileOrDirectory.ChangePermission.NOCHANGE);
            hooks.addHook(new TempDirDeleter(dir));
            return dir;
        }
        catch (CannotChangePermissionException | CannotCreateFileException | FileAlreadyExistsException | NoSuchFileException | NotDirectoryException | WrongPermissionException e) {
            throw new JackUserException(e);
        }
    }

    private static class TempDirDeleter
    implements Runnable {
        @Nonnull
        private final Directory dir;

        public TempDirDeleter(@Nonnull Directory dir) {
            this.dir = dir;
        }

        @Override
        public void run() {
            try {
                FileUtils.deleteDir(this.dir.getFile());
            }
            catch (IOException e) {
                throw new JackIOException("Failed to delete temporary " + this.dir.getLocation().getDescription(), e);
            }
        }
    }

    public static enum MultiDexKind {
        NONE,
        NATIVE,
        LEGACY;

    }

    @VariableName(value="strategy")
    public static enum SwitchEnumOptStrategy {
        FEEDBACK,
        ALWAYS,
        NEVER;

    }

    @VariableName(value="level")
    public static enum VerbosityLevel {
        ERROR("error"),
        WARNING("warning"),
        INFO("info"),
        DEBUG("debug"),
        TRACE("trace");

        @Nonnull
        private final String id;

        private VerbosityLevel(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    @VariableName(value="policy")
    public static enum AssertionPolicy implements HasDescription
    {
        ALWAYS("always check assert statements"),
        NEVER("remove assert statements"),
        RUNTIME("check according to runtime configuration");

        @Nonnull
        private final String description;

        private AssertionPolicy(String description) {
            this.description = description;
        }

        @Override
        @Nonnull
        public String getDescription() {
            return this.description;
        }
    }

    private static class DeprecatedVerbosity
    implements Reportable {
        @Nonnull
        private final VerbosityLevel verbosity;

        private DeprecatedVerbosity(@Nonnull VerbosityLevel verbosity) {
            this.verbosity = verbosity;
        }

        @Override
        @Nonnull
        public String getMessage() {
            return "Verbosity level '" + this.verbosity.name().toLowerCase() + "' is deprecated";
        }

        @Override
        @Nonnull
        public Reportable.ProblemLevel getDefaultProblemLevel() {
            return Reportable.ProblemLevel.WARNING;
        }
    }
}

