/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.coverage;

import com.android.jack.ir.ast.JMethod;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ProbeDescription {
    @Nonnegative
    private final int probeId;
    @Nonnull
    private final JMethod method;
    @Nonnull
    private final Map<Integer, ProbeLineData> lineToData = new HashMap<Integer, ProbeLineData>();

    public ProbeDescription(@Nonnegative int probeId, @Nonnull JMethod method) {
        this.probeId = probeId;
        this.method = method;
    }

    @Nonnegative
    public int getProbeId() {
        return this.probeId;
    }

    @Nonnull
    public JMethod getMethod() {
        return this.method;
    }

    @Nonnull
    public Map<Integer, ProbeLineData> getLineToData() {
        return this.lineToData;
    }

    public void incrementLine(@Nonnegative int line, @Nonnegative int nodesCount, boolean branchNode) {
        ProbeLineData probeData = this.lineToData.get(line);
        if (probeData == null) {
            probeData = new ProbeLineData();
            this.lineToData.put(line, probeData);
        }
        if (branchNode) {
            ProbeLineData probeLineData = probeData;
            probeLineData.branchesCount = probeLineData.branchesCount + nodesCount;
        } else {
            ProbeLineData probeLineData = probeData;
            probeLineData.nodesCount = probeLineData.nodesCount + nodesCount;
        }
    }

    public String toString() {
        return "Probe " + this.probeId;
    }

    public static class ProbeLineData {
        private int nodesCount;
        private int branchesCount;

        public int getNodesCount() {
            return this.nodesCount;
        }

        public int getBranchesCount() {
            return this.branchesCount;
        }
    }
}

