/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.coverage;

import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.ConditionalBasicBlock;
import com.android.jack.cfg.ControlFlowGraph;
import com.android.jack.cfg.EntryBlock;
import com.android.jack.cfg.SwitchBasicBlock;
import com.android.jack.cfg.ThrowBasicBlock;
import com.android.jack.coverage.CodeCoverage;
import com.android.jack.coverage.CodeCoverageMarker;
import com.android.jack.coverage.ProbeDescription;
import com.android.jack.coverage.ProbeMarker;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JVisitable;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Code coverage analyzer")
@Support(value={CodeCoverage.class})
@Constraint(need={CodeCoverageMarker.Initialized.class, ControlFlowGraph.class})
@Transform(add={CodeCoverageMarker.Analyzed.class, ProbeMarker.class}, modify={CodeCoverageMarker.class})
@Filter(value={TypeWithoutPrebuiltFilter.class})
public class CodeCoverageAnalyzer
implements RunnableSchedulable<JMethod> {
    public void run(@Nonnull JMethod m) {
        if (m.isNative() || m.isAbstract()) {
            return;
        }
        JDefinedClassOrInterface declaringClass = m.getEnclosingType();
        CodeCoverageMarker coverageMarker = (CodeCoverageMarker)declaringClass.getMarker(CodeCoverageMarker.class);
        if (coverageMarker == null) {
            return;
        }
        ControlFlowGraph controlFlowGraph = (ControlFlowGraph)m.getMarker(ControlFlowGraph.class);
        assert (controlFlowGraph != null) : "No control flow graph";
        CodeCoverageAnalyzer.analyzeCFG(m, controlFlowGraph, coverageMarker);
        CodeCoverageAnalyzer.findProbeLocations(controlFlowGraph);
    }

    private static void analyzeCFG(@Nonnull JMethod method, @Nonnull ControlFlowGraph controlFlowGraph, @Nonnull CodeCoverageMarker coverageMarker) {
        LinkedList<EntryBlock> blocks = new LinkedList<EntryBlock>();
        blocks.add(controlFlowGraph.getEntryNode());
        BasicBlock bb = (BasicBlock)blocks.poll();
        while (bb != null) {
            if (!bb.containsMarker(ProbeMarker.class)) {
                List predecessors = bb.getPredecessors();
                int predecessorsCount = predecessors.size();
                ProbeDescription probe = null;
                if (predecessorsCount == 0) {
                    probe = CodeCoverageAnalyzer.assignNewProbe(method, coverageMarker, bb);
                } else if (predecessorsCount > 1) {
                    probe = CodeCoverageAnalyzer.assignNewProbe(method, coverageMarker, bb);
                } else {
                    BasicBlock pred = (BasicBlock)predecessors.get(0);
                    int successorsOfPredecessorCount = pred.getSuccessors().size();
                    if (successorsOfPredecessorCount > 1) {
                        probe = CodeCoverageAnalyzer.assignNewProbe(method, coverageMarker, bb);
                    } else {
                        ProbeMarker probeMarker = (ProbeMarker)pred.getMarker(ProbeMarker.class);
                        assert (probeMarker != null);
                        bb.addMarker((Marker)probeMarker);
                        probe = probeMarker.getProbe();
                    }
                }
                assert (probe != null);
                for (JStatement st : bb.getStatements()) {
                    ProbeUpdater visitor = new ProbeUpdater(probe);
                    visitor.accept((JVisitable)st);
                }
                blocks.addAll(bb.getSuccessors());
            }
            bb = (BasicBlock)blocks.poll();
        }
        for (BasicBlock bb2 : controlFlowGraph.getNodes()) {
            if (!(bb2 instanceof ConditionalBasicBlock) && !(bb2 instanceof SwitchBasicBlock)) continue;
            JStatement branchStatement = (JStatement)bb2.getStatements().get(0);
            SourceInfo branchSourceInfo = branchStatement.getSourceInfo();
            for (BasicBlock succ : bb2.getSuccessors()) {
                ProbeMarker marker = (ProbeMarker)succ.getMarker(ProbeMarker.class);
                assert (marker != null);
                marker.getProbe().incrementLine(branchSourceInfo.getStartLine(), 1, true);
            }
        }
    }

    private static void findProbeLocations(@Nonnull ControlFlowGraph controlFlowGraph) {
        EntryBlock entryBlock = controlFlowGraph.getEntryNode();
        BasicBlock exitBlock = (BasicBlock)controlFlowGraph.getExitNode();
        for (BasicBlock bb : controlFlowGraph.getNodes()) {
            if (bb == entryBlock || bb == exitBlock) continue;
            ProbeMarker probeMarker = (ProbeMarker)bb.getMarker(ProbeMarker.class);
            assert (probeMarker != null);
            List successors = bb.getSuccessors();
            if (successors.size() > 1) {
                assert (CodeCoverageAnalyzer.doSuccessorsHaveDifferentProbes(probeMarker, successors));
                probeMarker.setInsertionBlock(bb);
                continue;
            }
            if (successors.size() == 1) {
                BasicBlock successor = (BasicBlock)successors.get(0);
                if (successor == exitBlock) {
                    probeMarker.setInsertionBlock(bb);
                    continue;
                }
                ProbeMarker successorProbeMarker = (ProbeMarker)successor.getMarker(ProbeMarker.class);
                assert (successorProbeMarker != null);
                if (successorProbeMarker.getProbe() == probeMarker.getProbe()) continue;
                probeMarker.setInsertionBlock(bb);
                continue;
            }
            assert (bb instanceof ThrowBasicBlock);
            probeMarker.setInsertionBlock(bb);
        }
    }

    private static boolean doSuccessorsHaveDifferentProbes(@Nonnull ProbeMarker marker, @Nonnull List<BasicBlock> successors) {
        for (BasicBlock bb : successors) {
            ProbeMarker probeMarker = (ProbeMarker)bb.getMarker(ProbeMarker.class);
            assert (probeMarker != null);
            if (probeMarker != marker) continue;
            return false;
        }
        return true;
    }

    private static ProbeDescription assignNewProbe(@Nonnull JMethod method, @Nonnull CodeCoverageMarker coverageMarker, @Nonnull BasicBlock bb) {
        ProbeDescription p = coverageMarker.createProbe(method);
        bb.addMarker((Marker)new ProbeMarker(p));
        return p;
    }

    private static class ProbeUpdater
    extends JVisitor {
        @Nonnull
        private final ProbeDescription probe;

        public ProbeUpdater(@Nonnull ProbeDescription probe) {
            this.probe = probe;
        }

        public void endVisit(@Nonnull JExpression x) {
            this.updateProbe(x.getSourceInfo());
        }

        public boolean visit(@Nonnull JIfStatement x) {
            this.accept((JVisitable)x.getIfExpr());
            return false;
        }

        public boolean visit(@Nonnull JSwitchStatement x) {
            this.accept((JVisitable)x.getExpr());
            return false;
        }

        public boolean visit(@Nonnull JStatement x) {
            this.updateProbe(x.getSourceInfo());
            return false;
        }

        private void updateProbe(@Nonnull SourceInfo sourceInfo) {
            int line = sourceInfo != SourceInfo.UNKNOWN ? sourceInfo.getStartLine() : -1;
            this.probe.incrementLine(line, 1, false);
        }
    }
}

