/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.print;

import com.android.sched.util.print.DataModel;
import com.android.sched.util.print.DataType;
import com.android.sched.util.print.DataView;
import com.android.sched.util.print.DataViewBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class DataModelListAdapter<T>
implements Iterable<Object>,
DataModel {
    @Nonnull
    private final List<T> rows = new ArrayList<T>();
    @Nonnull
    private final Converter<T> modeler;

    public DataModelListAdapter(@Nonnull Converter<T> modeler) {
        this.modeler = modeler;
    }

    @Nonnull
    public DataModelListAdapter<T> add(@Nonnull T data) {
        this.rows.add(data);
        return this;
    }

    @Nonnull
    public DataModelListAdapter<T> addAll(@Nonnull List<T> list) {
        this.rows.addAll(list);
        return this;
    }

    @Nonnull
    public DataModelListAdapter<T> addAll(@Nonnull T[] list) {
        for (T data : list) {
            this.add(data);
        }
        return this;
    }

    @Nonnull
    public DataModelListAdapter<T> addAll(@Nonnull Iterator<T> iter) {
        while (iter.hasNext()) {
            this.add(iter.next());
        }
        return this;
    }

    @Nonnegative
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            private final Iterator<T> iter;
            {
                this.iter = DataModelListAdapter.this.rows.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public DataModel next() {
                return DataModelListAdapter.this.modeler.apply(this.iter.next());
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    @Override
    @Nonnull
    public DataView getDataView() {
        return DataViewBuilder.getList(this.rows.size() == 0 ? DataType.NOTHING : this.modeler.apply(this.rows.get(0)).getDataView().getDataType()).build();
    }

    public static interface Converter<T> {
        @Nonnull
        public DataModel apply(@Nonnull T var1);
    }
}

