/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.tracer.watcher;

import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.log.EventType;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.ObjectAlloc;
import com.android.sched.util.log.stats.ObjectAllocImpl;
import com.android.sched.util.log.stats.Statistic;
import com.android.sched.util.log.stats.StatisticId;
import com.android.sched.util.log.tracer.watcher.ObjectWatcher;
import com.android.sched.util.log.tracer.watcher.WatcherInstaller;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class TotalAllocationWatcher
implements ObjectWatcher<Object> {
    @Nonnull
    private static final StatisticId<ObjectAlloc> ALLOCATIONS = new StatisticId<ObjectAlloc>("jack.allocation.object.total", "Total object and array allocations", ObjectAllocImpl.class, ObjectAlloc.class);

    @Override
    public boolean notifyInstantiation(@Nonnull Object object, @Nonnegative long size, int count, @Nonnull EventType notUsed, @CheckForNull StackTraceElement site) {
        try {
            TracerFactory.getTracer().getStatistic(ALLOCATIONS).recordAllocation(size);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return false;
    }

    @Override
    @Nonnull
    public ObjectWatcher.Statistics addSample(@Nonnull Object node, @CheckForNull ObjectWatcher.Statistics raw, @Nonnull EventType type) {
        throw new AssertionError();
    }

    @ImplementationName(iface=WatcherInstaller.class, name="total-object-alloc", description="record object and array allocations globally")
    public static class AllocationWatcherInstaller
    implements WatcherInstaller {
        @Override
        public void install(@Nonnull Tracer tracer) {
            tracer.registerWatcher(Object.class, TotalAllocationWatcher.class);
        }
    }

    static class Statistics
    implements ObjectWatcher.Statistics {
        Statistics() {
        }

        @Override
        public Iterator<Statistic> iterator() {
            throw new AssertionError();
        }
    }
}

