/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.tracer.watcher;

import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.log.EventType;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.ObjectAlloc;
import com.android.sched.util.log.stats.ObjectAllocImpl;
import com.android.sched.util.log.stats.Statistic;
import com.android.sched.util.log.stats.StatisticId;
import com.android.sched.util.log.tracer.watcher.ObjectWatcher;
import com.android.sched.util.log.tracer.watcher.WatcherInstaller;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ObjectAllocationWatcher
implements ObjectWatcher<Object> {
    @Nonnull
    private static final Map<Class<?>, StatisticId<ObjectAlloc>> objectStats = new ConcurrentHashMap();
    Tracer tracer = TracerFactory.getTracer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notifyInstantiation(@Nonnull Object object, @Nonnegative long size, int count, @Nonnull EventType notUsed, @CheckForNull StackTraceElement site) {
        Class<?> type = object.getClass();
        Class<ObjectAllocationWatcher> clazz = ObjectAllocationWatcher.class;
        synchronized (ObjectAllocationWatcher.class) {
            StatisticId<ObjectAlloc> id = objectStats.get(type);
            if (id == null) {
                String name = type.getName();
                id = new StatisticId<ObjectAlloc>("jack.allocation.object." + name, "Object allocation of type " + name, ObjectAllocImpl.class, ObjectAlloc.class);
                objectStats.put(type, id);
            }
            // ** MonitorExit[var9_7] (shouldn't be in output)
            try {
                TracerFactory.getTracer().getStatistic(id).recordAllocation(size);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return false;
        }
    }

    @Override
    @Nonnull
    public ObjectWatcher.Statistics addSample(@Nonnull Object node, @CheckForNull ObjectWatcher.Statistics raw, @Nonnull EventType type) {
        throw new AssertionError();
    }

    @ImplementationName(iface=WatcherInstaller.class, name="object-alloc", description="record object and array allocations type by type")
    public static class DetailedAllocationWatcherInstaller
    implements WatcherInstaller {
        @Override
        public void install(@Nonnull Tracer tracer) {
            tracer.registerWatcher(Object.class, ObjectAllocationWatcher.class);
        }
    }

    static class Statistics
    implements ObjectWatcher.Statistics {
        Statistics() {
        }

        @Override
        public Iterator<Statistic> iterator() {
            throw new AssertionError();
        }
    }
}

