/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.tracer;

import com.android.sched.util.codec.DirectoryCodec;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.config.Config;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.BooleanPropertyId;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.log.Event;
import com.android.sched.util.log.EventType;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Statistic;
import com.android.sched.util.log.stats.StatisticId;
import com.android.sched.util.log.tracer.AbstractTracer;
import com.android.sched.util.log.tracer.SimpleStat;
import com.android.sched.util.log.tracer.TemplateFtl;
import com.android.sched.util.log.tracer.TracerEventType;
import com.android.sched.util.log.tracer.filter.EventFilter;
import com.android.sched.util.log.tracer.probe.MemoryBytesProbe;
import com.android.sched.util.log.tracer.probe.Probe;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@ImplementationName(iface=Tracer.class, name="html")
@HasKeyId
public class StatsTracerFtl
extends AbstractTracer {
    @Nonnull
    public static final PropertyId<Directory> TRACER_DIR = PropertyId.create("sched.tracer.dir", "Define in which directory the tracer generates files", new DirectoryCodec(FileOrDirectory.Existence.MUST_EXIST, 3)).requiredIf(TracerFactory.TRACER.getClazz().isImplementedBy(StatsTracerFtl.class));
    @Nonnull
    public static final BooleanPropertyId TRACER_DIR_WITH_CONFIG = BooleanPropertyId.create("sched.tracer.dir.add-config-name", "Generate tracer files in an additional sub-directory named after the configuration").requiredIf(TracerFactory.TRACER.getClazz().isImplementedBy(StatsTracerFtl.class)).addDefaultValue(Boolean.FALSE);
    @Nonnull
    private final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final Directory dir;
    @Nonnull
    private final Map<EventType, Total> map = new HashMap<EventType, Total>();

    public StatsTracerFtl() {
        if (ThreadConfig.get(TRACER_DIR_WITH_CONFIG).booleanValue()) {
            try {
                this.dir = new Directory(ThreadConfig.get(TRACER_DIR).getFile().getPath() + File.separator + ThreadConfig.getConfig().getName(), null, FileOrDirectory.Existence.MAY_EXIST, 7, FileOrDirectory.ChangePermission.OWNER);
            }
            catch (CannotChangePermissionException | CannotCreateFileException | FileAlreadyExistsException | NoSuchFileException | NotDirectoryException | WrongPermissionException e) {
                throw new AssertionError((Object)e);
            }
        } else {
            this.dir = ThreadConfig.get(TRACER_DIR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    public void stopTracer() {
        Method method;
        this.map.remove(TracerEventType.OVERHEAD);
        HashMap<String, Object> modelRoot = new HashMap<String, Object>();
        ArrayList modelStats = new ArrayList();
        modelRoot.put("stats", modelStats);
        HashMap modelParams = new HashMap();
        modelRoot.put("probes", modelParams);
        ArrayList modelTemps = new ArrayList();
        modelRoot.put("templates", modelTemps);
        HashMap<String, Object> modelSysts = new HashMap<String, Object>();
        modelRoot.put("systems", modelSysts);
        modelRoot.put("descs", this.generateStatDescDataModel());
        Date date = new Date(System.currentTimeMillis());
        modelSysts.put("date", date.toString());
        modelSysts.put("config", this.getConfigFileName());
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        modelSysts.put("os_arch", os.getArch());
        modelSysts.put("os_proc_nb", os.getAvailableProcessors());
        modelSysts.put("os_name", os.getName());
        modelSysts.put("os_version", os.getVersion());
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        modelSysts.put("vm_name", runtime.getVmName());
        modelSysts.put("vm_vendor", runtime.getVmVendor());
        modelSysts.put("vm_version", runtime.getVmVersion());
        modelSysts.put("vm_options", Joiner.on(' ').skipNulls().join(runtime.getInputArguments()));
        modelSysts.put("vm_memory_max", MemoryBytesProbe.formatBytes(Runtime.getRuntime().maxMemory()));
        int first = 1;
        StringBuilder gcs = new StringBuilder();
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (first == 0) {
                gcs.append(", ");
            } else {
                first = 0;
            }
            gcs.append(gc.getName());
        }
        modelSysts.put("vm_collectors", gcs);
        try {
            modelSysts.put("host_name", InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        try {
            method = os.getClass().getMethod("getTotalPhysicalMemorySize", new Class[0]);
            method.setAccessible(true);
            modelSysts.put("os_memory_physical", MemoryBytesProbe.formatBytes((Long)method.invoke((Object)os, new Object[0])));
        }
        catch (Throwable gc) {
            // empty catch block
        }
        try {
            method = os.getClass().getMethod("getTotalSwapSpaceSize", new Class[0]);
            method.setAccessible(true);
            modelSysts.put("os_memory_swap", MemoryBytesProbe.formatBytes((Long)method.invoke((Object)os, new Object[0])));
        }
        catch (Throwable gc) {
            // empty catch block
        }
        try {
            method = os.getClass().getMethod("getCommittedVirtualMemorySize", new Class[0]);
            method.setAccessible(true);
            modelSysts.put("os_memory_committed", MemoryBytesProbe.formatBytes((Long)method.invoke((Object)os, new Object[0])));
        }
        catch (Throwable gc) {
            // empty catch block
        }
        ArrayList classProbes = new ArrayList();
        for (TemplateFtl[] probe : this.probeManager.getProbes()) {
            classProbes.add(probe.getClass());
        }
        ArrayList<TemplateFtl> templates = new ArrayList<TemplateFtl>();
        for (TemplateFtl template : TemplateFtl.values()) {
            if (!(template.getMandatoryProbes().size() > 0 && classProbes.containsAll(template.getMandatoryProbes()) || template.getOptionalProbes().size() > 0 && !Collections.disjoint(template.getOptionalProbes(), classProbes)) && (template.getMandatoryProbes().size() != 0 || template.getOptionalProbes().size() != 0)) continue;
            HashMap<String, Object> elt = new HashMap<String, Object>();
            elt.put("file", template.getTargetName());
            elt.put("name", template.getName());
            modelTemps.add(elt);
            templates.add(template);
        }
        ListIterator iterTemplate = templates.listIterator();
        while (iterTemplate.hasNext()) {
            BufferedWriter writer;
            int templateIdx = iterTemplate.nextIndex();
            TemplateFtl template = (TemplateFtl)((Object)iterTemplate.next());
            StringBuilder summary = new StringBuilder();
            boolean first2 = true;
            boolean hasFilter = false;
            modelStats.clear();
            modelParams.clear();
            ListIterator<Probe> iterProbe = this.probeManager.getProbes().listIterator();
            while (iterProbe.hasNext()) {
                int probeIndex = iterProbe.nextIndex();
                Probe probe = iterProbe.next();
                if (!template.getMandatoryProbes().contains(probe.getClass()) && !template.getOptionalProbes().contains(probe.getClass())) continue;
                String label = template.getLabel(probe.getClass());
                long total = 0L;
                for (Total c : Ordering.usingToString().immutableSortedCopy(this.map.values())) {
                    if (c.withChildrenValue[probeIndex].getTotal() == 0.0 && c.withoutChildrenValue[probeIndex].getTotal() == 0.0) continue;
                    HashMap<String, Object> elt = new HashMap<String, Object>();
                    elt.put("name", c.type.getName());
                    elt.put("file", this.getEventFileName(c.type));
                    elt.put("v_" + label + "_with", (long)c.withChildrenValue[probeIndex].getTotal());
                    elt.put("f_" + label + "_with", probe.formatValue((long)c.withChildrenValue[probeIndex].getTotal()));
                    elt.put("v_" + label + "_without", (long)c.withoutChildrenValue[probeIndex].getTotal());
                    elt.put("f_" + label + "_without", probe.formatValue((long)c.withoutChildrenValue[probeIndex].getTotal()));
                    modelStats.add(elt);
                    total = (long)((double)total + c.withoutChildrenValue[probeIndex].getTotal());
                }
                HashMap<String, Object> elt = new HashMap<String, Object>();
                elt.put("name", probe.getDescription());
                elt.put("v_Total", total);
                elt.put("f_Total", probe.formatValue(total));
                EventFilter filter = this.probeManager.getFilter(probe);
                if (filter != null) {
                    hasFilter = true;
                    elt.put("filter", filter.getDescription());
                }
                modelParams.put(label, elt);
                if (!first2) {
                    summary.append(", ");
                } else {
                    first2 = false;
                }
                summary.append(probe.getDescription());
                summary.append(": ");
                summary.append(probe.formatValue(total));
            }
            if (summary.length() > 0) {
                ((Map)modelTemps.get(templateIdx)).put("summary", summary.toString());
            }
            ((Map)modelTemps.get(templateIdx)).put("filter", Boolean.valueOf(hasFilter).toString());
            Configuration config = new Configuration();
            config.setClassForTemplateLoading(StatsTracerFtl.class, "templates/");
            config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            config.setNumberFormat("0.######");
            File file = new File(this.dir.getFile(), template.getTargetName());
            try {
                writer = new BufferedWriter(new FileWriter(file), 102400);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Unable to open tracer file '" + file.getAbsolutePath() + "'", e);
                return;
            }
            this.logger.log(Level.FINER, "Produce template ''{0}'' in file ''{1}''", new Object[]{template.getTemplateName(), file.getAbsolutePath()});
            try {
                Template tmp = config.getTemplate(template.getTemplateName());
                try {
                    tmp.process(modelRoot, (Writer)writer);
                }
                catch (IOException e) {
                    this.logger.log(Level.SEVERE, "Unable to write tracer file '" + file.getAbsolutePath() + "'", e);
                    try {
                        ((Writer)writer).flush();
                        ((Writer)writer).close();
                    }
                    catch (IOException e2) {
                        this.logger.log(Level.SEVERE, "Unable to close tracer file '" + file.getAbsolutePath() + "'", e2);
                    }
                    return;
                }
                catch (TemplateException e) {
                    this.logger.log(Level.SEVERE, "Unable to use template '" + template.getTemplateName() + "'", e);
                    try {
                        ((Writer)writer).flush();
                        ((Writer)writer).close();
                    }
                    catch (IOException e3) {
                        this.logger.log(Level.SEVERE, "Unable to close tracer file '" + file.getAbsolutePath() + "'", e3);
                    }
                    continue;
                    catch (IOException e4) {
                        this.logger.log(Level.SEVERE, "Unable to read template '" + template.getTemplateName() + "'", e4);
                    }
                }
            }
            finally {
                try {
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                }
                catch (IOException e) {
                    this.logger.log(Level.SEVERE, "Unable to close tracer file '" + file.getAbsolutePath() + "'", e);
                }
            }
        }
        for (Total total : this.map.values()) {
            this.generateEventReport(total);
        }
        for (StatisticId id : this.getStatisticsIds()) {
            this.generateStatReport(id);
        }
        this.generateConfigReport();
    }

    @CheckForNull
    private String getFileName(@Nonnull Object object) {
        if (object instanceof EventType) {
            return this.getEventFileName((EventType)object);
        }
        if (object instanceof StatisticId) {
            return this.getStatFileName((StatisticId)object);
        }
        return null;
    }

    @Nonnull
    private String getEventFileName(@Nonnull EventType type) {
        return "event-" + type.getName().replace(' ', '_').replace('\'', '_').replace('\"', '_').replace(':', '_') + ".html";
    }

    @Nonnull
    private String getStatFileName(@Nonnull StatisticId<? extends Statistic> id) {
        return "stat-" + id.getName().replace(' ', '_').replace('\'', '_').replace('\"', '_').replace(':', '_') + ".html";
    }

    @Nonnull
    private String getConfigFileName() {
        return "config.html";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateEventReport(@Nonnull Total total) {
        BufferedWriter writer;
        int idx;
        ArrayList<Object> dmData;
        ImmutableList statIds;
        Map[] rawStat;
        ArrayList dmDatas;
        SimpleStat stat;
        ArrayList<Object> dmData2;
        Probe probe;
        ArrayList dmDatas2;
        Object dmHeader;
        HashMap<String, Object> dmTable;
        String template = "event.html.ftl";
        HashMap<String, Object> dmRoot = new HashMap<String, Object>();
        dmRoot.put("name", "Event " + total.type.getName());
        ArrayList dmTables = new ArrayList();
        dmRoot.put("tables", dmTables);
        if (!total.children.isEmpty()) {
            dmTable = new HashMap<String, Object>();
            dmTables.add(dmTable);
            dmTable.put("name", "Children");
            dmHeader = new ArrayList<String>();
            dmTable.put("header", dmHeader);
            dmDatas2 = new ArrayList();
            dmTable.put("data", dmDatas2);
            dmHeader.add("Name");
            dmHeader.add("string");
            for (EventType type : Ordering.usingToString().immutableSortedCopy(total.children)) {
                ArrayList<String> dmData3 = new ArrayList<String>();
                dmDatas2.add(dmData3);
                dmData3.add(type.getName().replace("'", "\\'"));
                dmData3.add(this.getEventFileName(type));
            }
        }
        dmTable = new HashMap();
        dmTables.add(dmTable);
        if (total.children.isEmpty()) {
            dmTable.put("name", "Probes");
        } else {
            dmTable.put("name", "Probes without children");
        }
        dmHeader = new ArrayList();
        dmTable.put("header", dmHeader);
        dmDatas2 = new ArrayList();
        dmTable.put("data", dmDatas2);
        dmHeader.add("Probe");
        dmHeader.add("string");
        dmHeader.add("Count");
        dmHeader.add("number");
        dmHeader.add("Total");
        dmHeader.add("number");
        dmHeader.add("Min");
        dmHeader.add("number");
        dmHeader.add("Average");
        dmHeader.add("number");
        dmHeader.add("Max");
        dmHeader.add("number");
        ListIterator<Probe> iter = this.probeManager.getProbes().listIterator();
        while (iter.hasNext()) {
            int idx2 = iter.nextIndex();
            probe = iter.next();
            dmData2 = new ArrayList<Object>();
            dmDatas2.add(dmData2);
            dmData2.add(probe.getDescription().replace("'", "\\'"));
            dmData2.add("");
            stat = total.withoutChildrenValue[idx2];
            this.addProbe(dmData2, stat.getCount(), null);
            this.addProbe(dmData2, stat.getTotal(), probe);
            this.addProbe(dmData2, stat.getMin(), probe);
            this.addProbe(dmData2, stat.getAverage(), probe);
            this.addProbe(dmData2, stat.getMax(), probe);
        }
        if (!total.children.isEmpty()) {
            dmTable = new HashMap();
            dmTables.add(dmTable);
            dmTable.put("name", "Probes with children");
            dmHeader = new ArrayList();
            dmTable.put("header", dmHeader);
            dmDatas2 = new ArrayList();
            dmTable.put("data", dmDatas2);
            dmHeader.add("Probe");
            dmHeader.add("string");
            dmHeader.add("Count");
            dmHeader.add("number");
            dmHeader.add("Total");
            dmHeader.add("number");
            dmHeader.add("Min");
            dmHeader.add("number");
            dmHeader.add("Average");
            dmHeader.add("number");
            dmHeader.add("Max");
            dmHeader.add("number");
            iter = this.probeManager.getProbes().listIterator();
            while (iter.hasNext()) {
                int idx3 = iter.nextIndex();
                probe = iter.next();
                dmData2 = new ArrayList();
                dmDatas2.add(dmData2);
                dmData2.add(probe.getDescription().replace("'", "\\'"));
                dmData2.add("");
                stat = total.withChildrenValue[idx3];
                this.addProbe(dmData2, stat.getCount(), null);
                this.addProbe(dmData2, stat.getTotal(), probe);
                this.addProbe(dmData2, stat.getMin(), probe);
                this.addProbe(dmData2, stat.getAverage(), probe);
                this.addProbe(dmData2, stat.getMax(), probe);
            }
        }
        ImmutableList<Statistic> dummies = Ordering.usingToString().immutableSortedCopy(StatisticId.getDummies());
        for (Statistic dummy : dummies) {
            HashMap<String, Object> dmTable2 = new HashMap<String, Object>();
            dmTables.add(dmTable2);
            dmTable2.put("name", "Statistics " + (total.children.isEmpty() ? "(" : "without Children (") + dummy.getDescription() + ")");
            ArrayList<String> dmHeader2 = new ArrayList<String>();
            dmTable2.put("header", dmHeader2);
            dmDatas = new ArrayList();
            dmTable2.put("data", dmDatas);
            dmHeader2.add("Statistic");
            dmHeader2.add("string");
            for (int idx4 = 0; idx4 < dummy.getDataView().getDataCount(); ++idx4) {
                dmHeader2.add(dummy.getDescription(idx4));
                dmHeader2.add(dummy.getType(idx4));
            }
            rawStat = (Map[])this.globalStatistics.get(total.type);
            if (rawStat == null) continue;
            statIds = Ordering.usingToString().immutableSortedCopy(rawStat[AbstractTracer.Children.WITHOUT.ordinal()].keySet());
            for (StatisticId statId : statIds) {
                Statistic woStat = (Statistic)rawStat[AbstractTracer.Children.WITHOUT.ordinal()].get(statId);
                if (woStat == null || StatisticId.getRegularClass(dummy.getClass()) != woStat.getClass()) continue;
                dmData = new ArrayList<Object>();
                dmDatas.add(dmData);
                dmData.add(statId.getName().replace("'", "\\'"));
                dmData.add(this.getStatFileName(statId));
                for (idx = 0; idx < dummy.getDataView().getDataCount(); ++idx) {
                    assert (woStat.getHumanReadableValue(idx) != null);
                    if (dummy.getType(idx).equals("string")) {
                        dmData.add(woStat.getHumanReadableValue(idx).replace("'", "\\'"));
                        dmData.add(this.getFileName(woStat.getValue(idx)));
                        continue;
                    }
                    assert (woStat.getValue(idx) != null);
                    dmData.add(woStat.getValue(idx));
                    dmData.add(woStat.getHumanReadableValue(idx));
                }
            }
        }
        if (!total.children.isEmpty()) {
            for (Statistic dummy : dummies) {
                HashMap<String, Object> dmStat = new HashMap<String, Object>();
                dmTables.add(dmStat);
                dmStat.put("name", "Statistics with Children (" + dummy.getDescription() + ")");
                ArrayList<String> dmHeader3 = new ArrayList<String>();
                dmStat.put("header", dmHeader3);
                dmDatas = new ArrayList();
                dmStat.put("data", dmDatas);
                dmHeader3.add("Statistic");
                dmHeader3.add("string");
                for (int idx5 = 0; idx5 < dummy.getDataView().getDataCount(); ++idx5) {
                    dmHeader3.add(dummy.getDescription(idx5));
                    dmHeader3.add(dummy.getType(idx5));
                }
                rawStat = (Map[])this.globalStatistics.get(total.type);
                if (rawStat == null) continue;
                statIds = Ordering.usingToString().immutableSortedCopy(rawStat[AbstractTracer.Children.WITH.ordinal()].keySet());
                for (StatisticId statId : statIds) {
                    Statistic wStat = (Statistic)rawStat[AbstractTracer.Children.WITH.ordinal()].get(statId);
                    if (wStat == null || StatisticId.getRegularClass(dummy.getClass()) != wStat.getClass()) continue;
                    dmData = new ArrayList();
                    dmDatas.add(dmData);
                    dmData.add(statId.getName().replace("'", "\\'"));
                    dmData.add(this.getStatFileName(statId));
                    for (idx = 0; idx < dummy.getDataView().getDataCount(); ++idx) {
                        assert (wStat.getHumanReadableValue(idx) != null);
                        if (dummy.getType(idx).equals("string")) {
                            dmData.add(wStat.getHumanReadableValue(idx).replace("'", "\\'"));
                            dmData.add(this.getFileName(wStat.getValue(idx)));
                            continue;
                        }
                        assert (wStat.getValue(idx) != null);
                        dmData.add(wStat.getValue(idx));
                        dmData.add(wStat.getHumanReadableValue(idx));
                    }
                }
            }
        }
        Configuration config = new Configuration();
        config.setClassForTemplateLoading(StatsTracerFtl.class, "templates/");
        config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        config.setNumberFormat("0.######");
        File file = new File(this.dir.getFile(), this.getEventFileName(total.type));
        try {
            writer = new BufferedWriter(new FileWriter(file), 102400);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Unable to open tracer file '" + file.getAbsolutePath() + "'", e);
            return;
        }
        this.logger.log(Level.FINER, "Produce template ''{0}'' in file ''{1}''", new Object[]{template, file.getAbsolutePath()});
        try {
            Template tmp = config.getTemplate(template);
            try {
                tmp.process(dmRoot, (Writer)writer);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Unable to write tracer file '" + file.getAbsolutePath() + "'", e);
                try {
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                }
                catch (IOException e2) {
                    this.logger.log(Level.SEVERE, "Unable to close tracer file '" + file.getAbsolutePath() + "'", e2);
                }
                return;
            }
            catch (TemplateException e) {
                try {
                    this.logger.log(Level.SEVERE, "Unable to use template '" + template + "'", e);
                }
                catch (IOException e3) {
                    this.logger.log(Level.SEVERE, "Unable to read template '" + template + "'", e3);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                ((Writer)writer).flush();
                ((Writer)writer).close();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Unable to close tracer file '" + file.getAbsolutePath() + "'", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateStatReport(@Nonnull StatisticId<? extends Statistic> id) {
        BufferedWriter writer;
        int idx;
        ArrayList<Object> dmData;
        Map[] rawStat;
        String template = "event.html.ftl";
        HashMap<String, Object> dmRoot = new HashMap<String, Object>();
        dmRoot.put("name", id.getName());
        dmRoot.put("description", id.getDescription());
        ArrayList dmTables = new ArrayList();
        dmRoot.put("tables", dmTables);
        ImmutableList<Total> totals = Ordering.usingToString().immutableSortedCopy(this.map.values());
        HashMap<String, Object> dmStat = new HashMap<String, Object>();
        dmTables.add(dmStat);
        dmStat.put("name", "Without Children");
        ArrayList<String> dmHeader = new ArrayList<String>();
        dmStat.put("header", dmHeader);
        ArrayList dmDatas = new ArrayList();
        dmStat.put("data", dmDatas);
        dmHeader.add("Event");
        dmHeader.add("string");
        Statistic dummy = id.getDummyInstance();
        for (int idx2 = 0; idx2 < dummy.getDataView().getDataCount(); ++idx2) {
            dmHeader.add(dummy.getDescription(idx2));
            dmHeader.add(dummy.getType(idx2));
        }
        for (Total total : totals) {
            Statistic woStat;
            rawStat = (Map[])this.globalStatistics.get(total.type);
            if (rawStat == null || (woStat = (Statistic)rawStat[AbstractTracer.Children.WITHOUT.ordinal()].get(id)) == null) continue;
            dmData = new ArrayList<Object>();
            dmDatas.add(dmData);
            dmData.add(total.type.getName().replace("'", "\\'"));
            dmData.add(this.getEventFileName(total.type));
            for (idx = 0; idx < dummy.getDataView().getDataCount(); ++idx) {
                assert (woStat.getHumanReadableValue(idx) != null);
                if (dummy.getType(idx).equals("string")) {
                    dmData.add(woStat.getHumanReadableValue(idx).replace("'", "\\'"));
                    dmData.add(this.getFileName(woStat.getValue(idx)));
                    continue;
                }
                assert (woStat.getValue(idx) != null);
                dmData.add(woStat.getValue(idx));
                dmData.add(woStat.getHumanReadableValue(idx));
            }
        }
        dmStat = new HashMap();
        dmTables.add(dmStat);
        dmStat.put("name", "With Children");
        dmHeader = new ArrayList();
        dmStat.put("header", dmHeader);
        dmDatas = new ArrayList();
        dmStat.put("data", dmDatas);
        dmHeader.add("Event");
        dmHeader.add("string");
        dummy = id.getDummyInstance();
        for (int idx3 = 0; idx3 < dummy.getDataView().getDataCount(); ++idx3) {
            dmHeader.add(dummy.getDescription(idx3));
            dmHeader.add(dummy.getType(idx3));
        }
        for (Total total : totals) {
            Statistic wStat;
            rawStat = (Map[])this.globalStatistics.get(total.type);
            if (rawStat == null || (wStat = (Statistic)rawStat[AbstractTracer.Children.WITH.ordinal()].get(id)) == null) continue;
            dmData = new ArrayList();
            dmDatas.add(dmData);
            dmData.add(total.type.getName().replace("'", "\\'"));
            dmData.add(this.getEventFileName(total.type));
            for (idx = 0; idx < dummy.getDataView().getDataCount(); ++idx) {
                assert (wStat.getHumanReadableValue(idx) != null);
                if (dummy.getType(idx).equals("string")) {
                    dmData.add(wStat.getHumanReadableValue(idx).replace("'", "\\'"));
                    dmData.add(this.getFileName(wStat.getValue(idx)));
                    continue;
                }
                assert (wStat.getValue(idx) != null);
                dmData.add(wStat.getValue(idx));
                dmData.add(wStat.getHumanReadableValue(idx));
            }
        }
        Configuration config = new Configuration();
        config.setClassForTemplateLoading(StatsTracerFtl.class, "templates/");
        config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        config.setNumberFormat("0.######");
        File file = new File(this.dir.getFile(), this.getStatFileName(id));
        try {
            writer = new BufferedWriter(new FileWriter(file), 102400);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Unable to open tracer file '" + file.getAbsolutePath() + "'", e);
            return;
        }
        this.logger.log(Level.FINER, "Produce template ''{0}'' in file ''{1}''", new Object[]{template, file.getAbsolutePath()});
        try {
            Template tmp = config.getTemplate(template);
            try {
                tmp.process(dmRoot, (Writer)writer);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Unable to write tracer file '" + file.getAbsolutePath() + "'", e);
                try {
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                }
                catch (IOException e2) {
                    this.logger.log(Level.SEVERE, "Unable to close tracer file '" + file.getAbsolutePath() + "'", e2);
                }
                return;
            }
            catch (TemplateException e) {
                try {
                    this.logger.log(Level.SEVERE, "Unable to use template '" + template + "'", e);
                }
                catch (IOException e3) {
                    this.logger.log(Level.SEVERE, "Unable to read template '" + template + "'", e3);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                ((Writer)writer).flush();
                ((Writer)writer).close();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Unable to close tracer file '" + file.getAbsolutePath() + "'", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateConfigReport() {
        BufferedWriter writer;
        String template = "event.html.ftl";
        HashMap<String, Object> dmRoot = new HashMap<String, Object>();
        dmRoot.put("name", "Configuration");
        ArrayList dmTables = new ArrayList();
        dmRoot.put("tables", dmTables);
        HashMap<String, Object> dmStat = new HashMap<String, Object>();
        dmTables.add(dmStat);
        dmStat.put("name", "Properties");
        ArrayList<String> dmHeader = new ArrayList<String>();
        dmStat.put("header", dmHeader);
        ArrayList dmDatas = new ArrayList();
        dmStat.put("data", dmDatas);
        dmHeader.add("Name");
        dmHeader.add("string");
        dmHeader.add("Value");
        dmHeader.add("string");
        dmHeader.add("Description");
        dmHeader.add("string");
        Config config = ThreadConfig.getConfig();
        Collection<PropertyId<?>> ids = config.getPropertyIds();
        for (PropertyId propertyId : Ordering.usingToString().immutableSortedCopy(ids)) {
            if (!config.hasValue(propertyId)) continue;
            ArrayList<String> dmData = new ArrayList<String>();
            dmDatas.add(dmData);
            dmData.add(propertyId.getName().replace("'", "\\'"));
            dmData.add("");
            dmData.add(config.getAsString(propertyId).replace("'", "\\'"));
            dmData.add("");
            dmData.add(propertyId.getDescription().replace("'", "\\'"));
            dmData.add("");
        }
        Configuration configuration = new Configuration();
        configuration.setClassForTemplateLoading(StatsTracerFtl.class, "templates/");
        configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        configuration.setNumberFormat("0.######");
        File file = new File(this.dir.getFile(), this.getConfigFileName());
        try {
            writer = new BufferedWriter(new FileWriter(file), 102400);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Unable to open tracer file '" + file.getAbsolutePath() + "'", e);
            return;
        }
        this.logger.log(Level.FINER, "Produce template ''{0}'' in file ''{1}''", new Object[]{template, file.getAbsolutePath()});
        try {
            Template tmp = configuration.getTemplate(template);
            try {
                tmp.process(dmRoot, (Writer)writer);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Unable to write tracer file '" + file.getAbsolutePath() + "'", e);
                try {
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                }
                catch (IOException e2) {
                    this.logger.log(Level.SEVERE, "Unable to close tracer file '" + file.getAbsolutePath() + "'", e2);
                }
                return;
            }
            catch (TemplateException e) {
                try {
                    this.logger.log(Level.SEVERE, "Unable to use template '" + template + "'", e);
                }
                catch (IOException e3) {
                    this.logger.log(Level.SEVERE, "Unable to read template '" + template + "'", e3);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                ((Writer)writer).flush();
                ((Writer)writer).close();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Unable to close tracer file '" + file.getAbsolutePath() + "'", e);
            }
        }
    }

    private void addProbe(@Nonnull List<Object> model, double value, @CheckForNull Probe probe) {
        model.add((long)value);
        if (probe != null) {
            model.add(probe.formatValue((long)value));
        } else {
            model.add(Long.toString((long)value));
        }
    }

    @Override
    public void processEvent(@Nonnull Event event) {
        this.processEventWithOverhead(event, new Stack<EventType>());
    }

    @Nonnull
    private long[] processEventWithOverhead(@Nonnull Event event, @Nonnull Stack<EventType> stack) {
        Probe probe;
        int idx;
        EventType eventType = event.getType();
        long[] overhead = new long[this.probeManager.getProbes().size()];
        stack.push(eventType);
        for (Event child : event.getChildren()) {
            if (child.getType() != TracerEventType.OVERHEAD) {
                long[] childOverhead = this.processEventWithOverhead(child, stack);
                for (idx = 0; idx < overhead.length; ++idx) {
                    int n = idx;
                    overhead[n] = overhead[n] + childOverhead[idx];
                }
                continue;
            }
            ListIterator<Probe> iter = this.probeManager.getProbes().listIterator();
            while (iter.hasNext()) {
                idx = iter.nextIndex();
                probe = iter.next();
                int n = idx;
                overhead[n] = overhead[n] + child.getElapsedValue(probe);
            }
        }
        stack.pop();
        ListIterator<Probe> iter = this.probeManager.getProbes().listIterator();
        while (iter.hasNext()) {
            int idx2 = iter.nextIndex();
            Probe probe2 = iter.next();
            event.adjustElapsedValue(probe2, -overhead[idx2]);
        }
        long[] withChildrenValue = new long[this.getProbeManager().getProbes().size()];
        long[] withoutChildrenValue = new long[this.getProbeManager().getProbes().size()];
        iter = this.probeManager.getProbes().listIterator();
        while (iter.hasNext()) {
            idx = iter.nextIndex();
            probe = iter.next();
            long duration = event.getElapsedValue(probe);
            int n = idx;
            withoutChildrenValue[n] = withoutChildrenValue[n] + duration;
            if (stack.contains(eventType)) continue;
            int n2 = idx;
            withChildrenValue[n2] = withChildrenValue[n2] + duration;
        }
        for (Event child : event.getChildren()) {
            if (child.getType() == TracerEventType.OVERHEAD) continue;
            iter = this.probeManager.getProbes().listIterator();
            while (iter.hasNext()) {
                int idx3 = iter.nextIndex();
                Probe probe3 = iter.next();
                int n = idx3;
                withoutChildrenValue[n] = withoutChildrenValue[n] - child.getElapsedValue(probe3);
            }
        }
        Total total = this.map.get(eventType);
        if (total == null) {
            total = new Total(eventType);
            this.map.put(eventType, total);
        }
        iter = this.probeManager.getProbes().listIterator();
        while (iter.hasNext()) {
            int idx4 = iter.nextIndex();
            Probe probe4 = iter.next();
            total.withChildrenValue[idx4].add(withChildrenValue[idx4], null);
            total.withoutChildrenValue[idx4].add(withoutChildrenValue[idx4], null);
        }
        for (Event child : event.getChildren()) {
            if (child.getType() == TracerEventType.OVERHEAD) continue;
            total.children.add(child.getType());
        }
        return overhead;
    }

    @Override
    public void flush() {
    }

    @Nonnull
    private Map<String, Object> generateStatDescDataModel() {
        HashMap<String, Object> dmStatList = new HashMap<String, Object>();
        dmStatList.put("name", "Statistics");
        ArrayList<String> dmHeader = new ArrayList<String>();
        dmStatList.put("header", dmHeader);
        ArrayList dmDatas = new ArrayList();
        dmStatList.put("data", dmDatas);
        dmHeader.add("Name");
        dmHeader.add("string");
        dmHeader.add("Description");
        dmHeader.add("string");
        Collection<StatisticId<? extends Statistic>> ids = this.getStatisticsIds();
        for (StatisticId statisticId : Ordering.usingToString().immutableSortedCopy(ids)) {
            ArrayList<String> dmData = new ArrayList<String>();
            dmDatas.add(dmData);
            dmData.add(statisticId.getName().replace("'", "\\'"));
            dmData.add(this.getFileName(statisticId));
            dmData.add(statisticId.getDescription().replace("'", "\\'"));
            dmData.add(null);
        }
        return dmStatList;
    }

    private class Total {
        @Nonnull
        EventType type;
        @Nonnull
        SimpleStat[] withChildrenValue;
        @Nonnull
        SimpleStat[] withoutChildrenValue;
        @Nonnull
        Set<EventType> children;

        Total(EventType type) {
            this.withChildrenValue = new SimpleStat[StatsTracerFtl.this.getProbeManager().getProbes().size()];
            this.withoutChildrenValue = new SimpleStat[StatsTracerFtl.this.getProbeManager().getProbes().size()];
            this.children = new HashSet<EventType>();
            this.type = type;
            for (int idx = 0; idx < StatsTracerFtl.this.getProbeManager().getProbes().size(); ++idx) {
                this.withChildrenValue[idx] = new SimpleStat();
                this.withoutChildrenValue[idx] = new SimpleStat();
            }
        }

        @Nonnull
        public String toString() {
            return this.type.getName();
        }
    }
}

