/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.stats;

import com.android.sched.util.HasDescription;
import com.android.sched.util.log.stats.StatisticId;
import com.android.sched.util.print.DataModel;
import com.android.sched.util.print.TextPrinter;
import com.google.common.collect.Iterators;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public abstract class Statistic
implements DataModel,
HasDescription {
    @Nonnull
    private final StatisticId<? extends Statistic> id;

    public abstract void merge(@Nonnull Statistic var1);

    protected Statistic(@Nonnull StatisticId<? extends Statistic> id) {
        this.id = id;
    }

    @Nonnull
    public StatisticId<? extends Statistic> getId() {
        return this.id;
    }

    @Nonnull
    public String toString() {
        return this.id.getName();
    }

    public boolean isEnabled() {
        return false;
    }

    @Nonnull
    @Deprecated
    public final String getDescription(@Nonnegative int columnIdx) {
        return this.getDataView().getDataNames()[columnIdx];
    }

    @Nonnull
    @Deprecated
    public final String getType(@Nonnegative int columnIdx) {
        switch (this.getDataView().getDataTypes()[columnIdx]) {
            case STRING: 
            case BUNDLE: {
                return "string";
            }
            case BOOLEAN: 
            case DURATION: 
            case NUMBER: 
            case PERCENT: 
            case QUANTITY: {
                return "number";
            }
            case LIST: 
            case NOTHING: 
            case STRUCT: {
                throw new AssertionError((Object)this.getDataView().getDataTypes()[columnIdx].toString());
            }
        }
        throw new AssertionError((Object)this.getDataView().getDataTypes()[columnIdx].toString());
    }

    @Nonnull
    @Deprecated
    public final Object getValue(@Nonnegative int columnIdx) {
        return Iterators.get(this.iterator(), columnIdx);
    }

    @Nonnull
    @Deprecated
    public final String getHumanReadableValue(@Nonnegative int columnIdx) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter printer = new PrintWriter(new PrintStream(baos));
        TextPrinter provider = new TextPrinter(printer);
        provider.getFormatter(this.getDataView().getDataTypes()[columnIdx]).print(printer, this.getValue(columnIdx));
        printer.close();
        return baos.toString();
    }
}

