/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.stats;

import com.android.sched.util.log.stats.ObjectAlloc;
import com.android.sched.util.log.stats.Statistic;
import com.android.sched.util.log.stats.StatisticId;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ObjectAllocImpl
extends ObjectAlloc {
    @Nonnegative
    private long number;
    @Nonnegative
    private long size = 0L;

    protected ObjectAllocImpl(@Nonnull StatisticId<? extends Statistic> id) {
        super(id);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public synchronized void recordAllocation(@Nonnegative long size) {
        ++this.number;
        this.size += size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void merge(@Nonnull Statistic statistic) {
        ObjectAllocImpl stat;
        ObjectAllocImpl objectAllocImpl = stat = (ObjectAllocImpl)statistic;
        synchronized (objectAllocImpl) {
            this.number += stat.number;
            this.size += stat.size;
        }
    }

    @Override
    @Nonnegative
    public long getNumber() {
        return this.number;
    }

    @Override
    @Nonnegative
    public long getSize() {
        return this.size;
    }
}

